/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.component.notify.message;

import com.bxm.newidea.component.notify.enums.NotifyMessageTypeEnum;
import com.bxm.newidea.component.notify.message.BaseNotifyMessage;
import java.util.List;

public class MarkdownNotifyMessage
extends BaseNotifyMessage {
    private boolean isUseMarkdownTemplate = false;
    private SubMarkdownContent subMarkdownContents;

    private MarkdownNotifyMessage() {
    }

    public boolean isUseMarkdownTemplate() {
        return this.isUseMarkdownTemplate;
    }

    public SubMarkdownContent getSubMarkdownContent() {
        return this.subMarkdownContents;
    }

    @Override
    public NotifyMessageTypeEnum getMessageType() {
        return NotifyMessageTypeEnum.MARK_DOWN;
    }

    public static class MarkdownNotifyMessageBuilder
    extends BaseNotifyMessage.BaseNotifyMessageBuilder<MarkdownNotifyMessageBuilder> {
        private SubMarkdownContent subMarkdownContents;
        private boolean isUseMarkdownTemplate;

        MarkdownNotifyMessageBuilder() {
            this.proxy = this;
        }

        public MarkdownNotifyMessageBuilder isUseMarkdownTemplate(boolean isuse) {
            this.isUseMarkdownTemplate = isuse;
            return this;
        }

        public MarkdownNotifyMessageBuilder addSubMarkdownContent(List<String> quoteContent) {
            this.subMarkdownContents = new SubMarkdownContent(quoteContent);
            return this;
        }

        public MarkdownNotifyMessageBuilder addSubMarkdownContent(String remark, List<String> quoteContent) {
            this.subMarkdownContents = new SubMarkdownContent(remark, quoteContent);
            return this;
        }

        public MarkdownNotifyMessageBuilder addSubMarkdownContent(String applicationName, String triggerRule, String triggerRuleUrl, String remark, List<String> quoteContent) {
            this.subMarkdownContents = new SubMarkdownContent(applicationName, triggerRule, triggerRuleUrl, remark, quoteContent);
            return this;
        }

        public MarkdownNotifyMessage build() {
            MarkdownNotifyMessage message = new MarkdownNotifyMessage();
            this.fillBaseFiled(message);
            return message;
        }
    }

    public static class SubMarkdownContent {
        private String applicationName;
        private String triggerRule;
        private String triggerRuleUrl;
        private List<String> quoteContent;
        private String remark;

        SubMarkdownContent(List<String> quoteContent) {
            this.quoteContent = quoteContent;
        }

        SubMarkdownContent(String remark, List<String> quoteContent) {
            this.remark = remark;
            this.quoteContent = quoteContent;
        }

        SubMarkdownContent(String applicationName, String triggerRule, String triggerRuleUrl, String remark, List<String> quoteContent) {
            this.applicationName = applicationName;
            this.triggerRule = triggerRule;
            this.triggerRuleUrl = triggerRuleUrl;
            this.remark = remark;
            this.quoteContent = quoteContent;
        }

        public String getApplicationName() {
            return this.applicationName;
        }

        public String getTriggerRule() {
            return this.triggerRule;
        }

        public String getTriggerRuleUrl() {
            return this.triggerRuleUrl;
        }

        public List<String> getQuoteContent() {
            return this.quoteContent;
        }

        public String getRemark() {
            return this.remark;
        }

        public void setApplicationName(String applicationName) {
            this.applicationName = applicationName;
        }

        public void setTriggerRule(String triggerRule) {
            this.triggerRule = triggerRule;
        }

        public void setTriggerRuleUrl(String triggerRuleUrl) {
            this.triggerRuleUrl = triggerRuleUrl;
        }

        public void setQuoteContent(List<String> quoteContent) {
            this.quoteContent = quoteContent;
        }

        public void setRemark(String remark) {
            this.remark = remark;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SubMarkdownContent)) {
                return false;
            }
            SubMarkdownContent other = (SubMarkdownContent)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$applicationName = this.getApplicationName();
            String other$applicationName = other.getApplicationName();
            if (this$applicationName == null ? other$applicationName != null : !this$applicationName.equals(other$applicationName)) {
                return false;
            }
            String this$triggerRule = this.getTriggerRule();
            String other$triggerRule = other.getTriggerRule();
            if (this$triggerRule == null ? other$triggerRule != null : !this$triggerRule.equals(other$triggerRule)) {
                return false;
            }
            String this$triggerRuleUrl = this.getTriggerRuleUrl();
            String other$triggerRuleUrl = other.getTriggerRuleUrl();
            if (this$triggerRuleUrl == null ? other$triggerRuleUrl != null : !this$triggerRuleUrl.equals(other$triggerRuleUrl)) {
                return false;
            }
            List<String> this$quoteContent = this.getQuoteContent();
            List<String> other$quoteContent = other.getQuoteContent();
            if (this$quoteContent == null ? other$quoteContent != null : !((Object)this$quoteContent).equals(other$quoteContent)) {
                return false;
            }
            String this$remark = this.getRemark();
            String other$remark = other.getRemark();
            return !(this$remark == null ? other$remark != null : !this$remark.equals(other$remark));
        }

        protected boolean canEqual(Object other) {
            return other instanceof SubMarkdownContent;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $applicationName = this.getApplicationName();
            result = result * 59 + ($applicationName == null ? 43 : $applicationName.hashCode());
            String $triggerRule = this.getTriggerRule();
            result = result * 59 + ($triggerRule == null ? 43 : $triggerRule.hashCode());
            String $triggerRuleUrl = this.getTriggerRuleUrl();
            result = result * 59 + ($triggerRuleUrl == null ? 43 : $triggerRuleUrl.hashCode());
            List<String> $quoteContent = this.getQuoteContent();
            result = result * 59 + ($quoteContent == null ? 43 : ((Object)$quoteContent).hashCode());
            String $remark = this.getRemark();
            result = result * 59 + ($remark == null ? 43 : $remark.hashCode());
            return result;
        }

        public String toString() {
            return "MarkdownNotifyMessage.SubMarkdownContent(applicationName=" + this.getApplicationName() + ", triggerRule=" + this.getTriggerRule() + ", triggerRuleUrl=" + this.getTriggerRuleUrl() + ", quoteContent=" + this.getQuoteContent() + ", remark=" + this.getRemark() + ")";
        }
    }
}

