package com.bxm.newidea.component.notify.assembly.dingding;

import com.bxm.newidea.component.JSON;
import com.bxm.newidea.component.notify.assembly.IMessageAssembler;
import com.bxm.newidea.component.notify.assembly.dingding.model.AtSub;
import com.bxm.newidea.component.notify.assembly.dingding.model.DingDingMarkdownDTO;
import com.bxm.newidea.component.notify.constant.NotifyMessageConstant;
import com.bxm.newidea.component.notify.message.MarkdownNotifyMessage;

/**
 * 钉钉markdown类消息组装
 *
 * @author liujia
 * @date 11/26/21 10:22 AM
 **/
public class DingdingMarkdownMessageAssembler implements IMessageAssembler<MarkdownNotifyMessage, String> {

    @Override
    public String platform() {
        return NotifyMessageConstant.Platform.DINGDING;
    }

    @Override
    public String assembler(MarkdownNotifyMessage message) {
        DingDingMarkdownDTO markdownDTO = new DingDingMarkdownDTO();
        markdownDTO.setAt(AtSub.get(message));
        markdownDTO.setMarkdown(new DingDingMarkdownDTO.MarkdownSub(message.getTitle(), message.getContent()));
        return JSON.toJSONString(markdownDTO);
    }
}
