package com.bxm.newidea.component.notify.assembly.dingding;

import com.bxm.newidea.component.JSON;
import com.bxm.newidea.component.notify.assembly.IMessageAssembler;
import com.bxm.newidea.component.notify.assembly.dingding.model.AtSub;
import com.bxm.newidea.component.notify.assembly.dingding.model.DingDingTextDTO;
import com.bxm.newidea.component.notify.constant.NotifyMessageConstant;
import com.bxm.newidea.component.notify.message.TextNotifyMessage;

/**
 * 钉钉文本类消息组装
 *
 * @author liujia
 * @date 11/26/21 10:22 AM
 **/
public class DingdingTextMessageAssembler implements IMessageAssembler<TextNotifyMessage, String> {

    @Override
    public String platform() {
        return NotifyMessageConstant.Platform.DINGDING;
    }

    @Override
    public String assembler(TextNotifyMessage message) {
        DingDingTextDTO textDTO = new DingDingTextDTO();
        textDTO.setText(new DingDingTextDTO.TextSub(message.getContent()));
        textDTO.setAt(AtSub.get(message));

        return JSON.toJSONString(textDTO);
    }
}
