package com.bxm.newidea.component.notify.assembly.dingding.model;

import lombok.Data;

/**
 * 钉钉文本格式参数
 * <p>
 * {
 * "at": {
 * "atMobiles":[
 * "180xxxxxx"
 * ],
 * "atUserIds":[
 * "user123"
 * ],
 * "isAtAll": false
 * },
 * "text": {
 * "getContent":"我就是我, @XXX 是不一样的烟火"
 * },
 * "msgtype":"text"
 * }
 *
 * @author JIY
 * @date 2021/11/24 18:56
 */
@Data
public class DingDingTextDTO {
    private String msgtype = "text";

    private TextSub text;

    private AtSub at;

    @Data
    public static class TextSub {
        public String content;

        public TextSub(String content) {
            this.content = content;
        }
    }
}
