package com.bxm.newidea.component.notify.channel.wechat;

import cn.hutool.http.HttpUtil;
import com.bxm.newidea.component.JSON;
import com.bxm.newidea.component.notify.assembly.MessageAssembler;
import com.bxm.newidea.component.notify.channel.IChannel;
import com.bxm.newidea.component.notify.channel.model.PublishResponse;
import com.bxm.newidea.component.notify.constant.NotifyMessageConstant;
import com.bxm.newidea.component.notify.message.NotifyMessage;
import com.bxm.newidea.component.notify.rule.IRule;
import lombok.extern.slf4j.Slf4j;

import java.util.Set;

@Slf4j
public class WechatChannel implements IChannel {

    private String webHook;

    public String getWebHook() {
        return webHook;
    }

    public void setWebHook(String webHook) {
        this.webHook = webHook;
    }

    @Override
    public <T extends NotifyMessage> boolean publish(T message) {
        String messageBody = MessageAssembler.assembly(this.platform(), message);
        String response = HttpUtil.post(getWebHook(), messageBody);

        PublishResponse responseObj = JSON.parseObject(response, PublishResponse.class);
        
        if (responseObj == null || responseObj.getErrcode() != 0) {
            log.info("企业微信消息发送失败，返回内容：{},消息主体：{}", responseObj, messageBody);
            return false;
        }
        return true;
    }

    @Override
    public Set<Class<? extends IRule>> bindRules() {
        return null;
    }

    @Override
    public String uniqueKey() {
        return getWebHook();
    }

    @Override
    public String platform() {
        return NotifyMessageConstant.Platform.WECHAT_GROUP;
    }
}
