package com.bxm.newidea.component.notify.message;

/**
 * 通知消息的统一构建者
 *
 * @author liujia
 * @date 11/25/21 9:12 PM
 **/
public class NotifyMessageBuilder {

    /**
     * 构建一个文本类型的消息
     *
     * @return 文本类型消息的构建者
     */
    public static TextNotifyMessage.TextNotifyMessageBuilder textMessage() {
        return new TextNotifyMessage.TextNotifyMessageBuilder();
    }

    /**
     * 构建一个卡片式的消息
     *
     * @return 卡片式消息构建者
     */
    public static CardNotifyMessage.CardNotifyMessageBuilder cardMessage() {
        return new CardNotifyMessage.CardNotifyMessageBuilder();
    }

    /**
     * 构建一个支持markdown的消息
     *
     * @return markdown的通知消息构建者
     */
    public static MarkdownNotifyMessage.MarkdownNotifyMessageBuilder markdownMessage() {
        return new MarkdownNotifyMessage.MarkdownNotifyMessageBuilder();
    }

}
