package com.bxm.newidea.component.notify.rule.impl;

import com.bxm.newidea.component.notify.message.NotifyMessage;
import com.bxm.newidea.component.notify.rule.IRule;
import com.bxm.newidea.component.tools.StringUtils;
import lombok.extern.slf4j.Slf4j;

/**
 * 快速失败处理规则
 *
 * @author liujia
 * @date 11/26/21 10:19 AM
 **/
@Slf4j
public class FastFailRule implements IRule {
    @Override
    public boolean accept(NotifyMessage message) {

        String title = message.getTitle();

        String content = message.getContent();

        if (StringUtils.isBlank(title) || StringUtils.isBlank(content)) {
            log.info("钉钉消息推送快速失败,标题和内容不能为空:{}", message);
            return false;
        }
        return true;
    }
}
