/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.component.notify.channel.wechat;

import cn.hutool.http.HttpUtil;
import com.bxm.newidea.component.JSON;
import com.bxm.newidea.component.notify.assembly.MessageAssembler;
import com.bxm.newidea.component.notify.channel.IChannel;
import com.bxm.newidea.component.notify.channel.model.PublishResponse;
import com.bxm.newidea.component.notify.message.NotifyMessage;
import com.bxm.newidea.component.notify.rule.IRule;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WechatChannel
implements IChannel {
    private static final Logger log = LoggerFactory.getLogger(WechatChannel.class);
    private String webHook;

    public String getWebHook() {
        return this.webHook;
    }

    public void setWebHook(String webHook) {
        this.webHook = webHook;
    }

    @Override
    public <T extends NotifyMessage> boolean publish(T message) {
        String messageBody = (String)MessageAssembler.assembly(this.platform(), message);
        String response = HttpUtil.post((String)this.getWebHook(), (String)messageBody);
        PublishResponse responseObj = (PublishResponse)JSON.parseObject((String)response, PublishResponse.class);
        if (responseObj == null || responseObj.getErrcode() != 0L) {
            log.info("\u4f01\u4e1a\u5fae\u4fe1\u6d88\u606f\u53d1\u9001\u5931\u8d25\uff0c\u8fd4\u56de\u5185\u5bb9\uff1a{},\u6d88\u606f\u4e3b\u4f53\uff1a{}", (Object)responseObj, (Object)messageBody);
            return false;
        }
        return true;
    }

    @Override
    public Set<Class<? extends IRule>> bindRules() {
        return null;
    }

    @Override
    public String uniqueKey() {
        return this.getWebHook();
    }

    @Override
    public String platform() {
        return "wechat";
    }
}

