/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.component.notify.config;

import com.bxm.newidea.component.notify.NotifyMessageSender;
import com.bxm.newidea.component.notify.channel.ChannelAgent;
import com.bxm.newidea.component.notify.interceptor.INotifyMessageInterceptor;
import com.bxm.newidea.component.notify.rule.IRule;
import com.bxm.newidea.component.notify.rule.RuleExecutor;
import com.bxm.newidea.component.thread.NamedThreadFactory;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

@Configuration(proxyBeanMethods=false)
public class ComponentNotifyMessageConfiguration {
    @Bean
    public NotifyMessageSender notifyMessageSender(@Qualifier(value="COMPONENT_NOTIFY_MESSAGE_EXECUTOR_BEAN") Executor executor, ChannelAgent channelAgent) {
        return new NotifyMessageSender(executor, channelAgent);
    }

    @Bean(value={"COMPONENT_NOTIFY_MESSAGE_EXECUTOR_BEAN"})
    @ConditionalOnMissingBean(name={"COMPONENT_NOTIFY_MESSAGE_EXECUTOR_BEAN"})
    public Executor notifyMessagePushExecutor() {
        ThreadPoolTaskExecutor executor = new ThreadPoolTaskExecutor();
        executor.setThreadFactory((ThreadFactory)new NamedThreadFactory("component-notify-message"));
        executor.setCorePoolSize(1);
        executor.setMaxPoolSize(5);
        executor.setQueueCapacity(500);
        executor.setRejectedExecutionHandler((RejectedExecutionHandler)new ThreadPoolExecutor.DiscardPolicy());
        return executor;
    }

    @Bean
    public ChannelAgent channelAgent(RuleExecutor executor, List<INotifyMessageInterceptor> messageInterceptor) {
        return new ChannelAgent(executor, messageInterceptor);
    }

    @Bean
    public RuleExecutor ruleExecutor(List<IRule> ruleList) {
        return new RuleExecutor(ruleList);
    }
}

