/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.component.notify.message;

import com.bxm.newidea.component.notify.channel.ChannelBuilder;
import com.bxm.newidea.component.notify.channel.IChannel;
import com.bxm.newidea.component.notify.message.NotifyMessage;
import com.bxm.newidea.component.notify.rule.IRule;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;

public abstract class BaseNotifyMessage
implements NotifyMessage {
    String title;
    String content;
    String mainReceiver;
    List<String> subReceiver;
    List<IChannel> channelList;
    List<Class<? extends IRule>> ruleList;
    Map<String, String> extendMap;

    BaseNotifyMessage() {
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public String getContent() {
        return this.content;
    }

    @Override
    public String getMainReceiver() {
        return this.mainReceiver;
    }

    @Override
    public List<String> getSubReceiver() {
        return this.subReceiver;
    }

    @Override
    public List<IChannel> getChannelList() {
        return this.channelList;
    }

    @Override
    public List<Class<? extends IRule>> getRuleList() {
        return this.ruleList;
    }

    @Override
    public Map<String, String> getExtendMap() {
        return this.extendMap;
    }

    protected static class BaseNotifyMessageBuilder<T extends BaseNotifyMessageBuilder> {
        String title;
        String content;
        String mainReceiver;
        List<String> subReceiverList = Lists.newArrayList();
        List<IChannel> channelList = Lists.newArrayList();
        List<Class<? extends IRule>> ruleList = Lists.newArrayList();
        Map<String, String> extendMap = Maps.newHashMap();
        T proxy;

        BaseNotifyMessageBuilder() {
        }

        public T title(String title) {
            this.title = title;
            return this.proxy;
        }

        public T content(String content) {
            this.content = content;
            return this.proxy;
        }

        public T mainReceiver(String mainReceiver) {
            this.mainReceiver = mainReceiver;
            return this.proxy;
        }

        public T addSubReceiver(String subReceiver) {
            this.subReceiverList.add(subReceiver);
            return this.proxy;
        }

        public T putExtend(String key, String value) {
            this.extendMap.put(key, value);
            return this.proxy;
        }

        public T bindChannel(IChannel channel) {
            this.channelList.add(channel);
            return this.proxy;
        }

        public T bindDingdingChannel(String dingdingUrl) {
            this.channelList.add(ChannelBuilder.dingding(dingdingUrl));
            return this.proxy;
        }

        public T bindRule(Class<? extends IRule> ruleClass) {
            this.ruleList.add(ruleClass);
            return this.proxy;
        }

        <M extends BaseNotifyMessage> void fillBaseFiled(M message) {
            message.title = this.title;
            message.content = this.content;
            message.channelList = this.channelList;
            message.ruleList = this.ruleList;
            message.mainReceiver = this.mainReceiver;
            message.subReceiver = this.subReceiverList;
            message.extendMap = this.extendMap;
        }
    }
}

