/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.component.office.excel.format.impl;

import com.bxm.component.office.excel.format.config.CellTypeEnum;
import com.bxm.component.office.excel.format.impl.AbstractCellConverter;
import com.bxm.newidea.component.tools.NumberUtils;
import java.math.BigDecimal;
import org.apache.poi.ss.usermodel.CellStyle;

public class NumericCellConverter
extends AbstractCellConverter {
    public int getOrder() {
        return 0;
    }

    @Override
    public boolean isMatch(CellTypeEnum cellType) {
        return CellTypeEnum.NUMERIC.equals((Object)cellType);
    }

    @Override
    public void setValue() {
        Object value = this.getSetValue();
        if (null == value) {
            value = "0";
        }
        this.getCell().setCellType(0);
        CellStyle cellStyle = this.getCell().getCellStyle();
        if (cellStyle.getAlignment() != 3) {
            String converterCellStyleKey = NumericCellConverter.class.getSimpleName();
            CellStyle numCellStyle = (CellStyle)this.getContext().getExtend(converterCellStyleKey);
            if (null == numCellStyle) {
                numCellStyle = this.getContext().getWorkbook().createCellStyle();
                numCellStyle.cloneStyleFrom(cellStyle);
                numCellStyle.setAlignment((short)3);
                this.getContext().addExtend(converterCellStyleKey, numCellStyle);
            }
            this.getCell().setCellStyle(numCellStyle);
        }
        this.getCell().setCellValue(value.toString());
    }

    @Override
    public Object getValue() {
        int cellType = this.getCell().getCellType();
        Double value = null;
        if (0 == cellType) {
            value = this.getCell().getNumericCellValue();
        } else if (1 == cellType) {
            value = NumberUtils.parseToDouble((String)this.getCell().getStringCellValue());
        }
        Class<?> clasz = this.getValueClass();
        if (null == value) {
            return 0;
        }
        if (BigDecimal.class.equals(clasz)) {
            return new BigDecimal(value);
        }
        if (Double.class.equals(clasz) || Double.TYPE.equals(clasz)) {
            return value;
        }
        if (Float.class.equals(clasz) || Float.TYPE.equals(clasz)) {
            return new Float(value);
        }
        if (Integer.class.equals(clasz) || Integer.TYPE.equals(clasz)) {
            return value.intValue();
        }
        if (Short.class.equals(clasz) || Short.TYPE.equals(clasz)) {
            return value.shortValue();
        }
        if (Long.class.equals(clasz) || Long.TYPE.equals(clasz)) {
            return value.longValue();
        }
        return value;
    }
}

