/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.component.office.excel.format;

import com.bxm.component.office.excel.format.CellValueConvertContext;
import com.bxm.component.office.excel.format.CellValueConverter;
import com.bxm.component.office.excel.format.impl.BooleanCellConverter;
import com.bxm.component.office.excel.format.impl.DateCellConverter;
import com.bxm.component.office.excel.format.impl.DefaultCellConverter;
import com.bxm.component.office.excel.format.impl.MoneyCellConverter;
import com.bxm.component.office.excel.format.impl.NumericCellConverter;
import com.bxm.component.office.excel.format.impl.StringCellConverter;
import com.bxm.component.office.excel.format.impl.TextCellConverter;
import com.bxm.component.office.excel.format.impl.TimestampCellConverter;
import com.bxm.component.office.excel.parse.setting.ParseHeader;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.apache.poi.ss.usermodel.CellType;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.annotation.Scope;
import org.springframework.core.Ordered;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

@Component
@Scope(value="prototype")
public class CellValueManage
implements InitializingBean {
    private List<CellValueConverter> converters = new ArrayList<CellValueConverter>();
    private CellValueConvertContext context = new CellValueConvertContext();

    public CellValueConvertContext getContext() {
        return this.context;
    }

    public void setValue() {
        if (this.context.getCell() == null) {
            return;
        }
        for (CellValueConverter converter : this.converters) {
            if (!converter.isMatch(this.context.getCellType())) continue;
            converter.setValue();
            break;
        }
    }

    public Object getValue() {
        if (null == this.context.getCell()) {
            return null;
        }
        Assert.notNull((Object)((Object)this.context.getCellType()), (String)"\u5217\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        Object value = null;
        if (this.context.getCell().getCellType() != CellType.BLANK) {
            for (CellValueConverter converter : this.converters) {
                if (converter.isMatch(this.context.getCellType()) && null != (value = converter.getValue())) break;
            }
        }
        ParseHeader header = (ParseHeader)this.context.getExtend("PARSE_HEADER");
        if (null == value && null != header && null != header.getDefaultValue()) {
            value = header.getDefaultValue().getValue();
        }
        return value;
    }

    public void addConverter(CellValueConverter converter) {
        this.registerConverter(converter);
        this.sort();
    }

    private void sort() {
        this.converters.sort(Comparator.comparingInt(Ordered::getOrder));
    }

    private void registerConverter(CellValueConverter converter) {
        converter.setCellValueManage(this);
        this.converters.add(converter);
    }

    public void afterPropertiesSet() {
        this.registerConverter(new StringCellConverter());
        this.registerConverter(new DateCellConverter());
        this.registerConverter(new TimestampCellConverter());
        this.registerConverter(new MoneyCellConverter());
        this.registerConverter(new NumericCellConverter());
        this.registerConverter(new TextCellConverter());
        this.registerConverter(new DefaultCellConverter());
        this.registerConverter(new BooleanCellConverter());
        this.sort();
    }
}

