/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.component.office.excel.parse.impl;

import com.bxm.component.office.excel.format.config.CellTypeEnum;
import com.bxm.component.office.excel.format.impl.AbstractCellConverter;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.poi.ss.usermodel.CellType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefinedDataCellFormat
extends AbstractCellConverter {
    private static final Logger log = LoggerFactory.getLogger(DefinedDataCellFormat.class);

    @Override
    public boolean isMatch(CellTypeEnum cellType) {
        return CellTypeEnum.DATE.equals((Object)cellType);
    }

    @Override
    public void setValue() {
    }

    @Override
    public Object getValue() {
        Class<?> clasz = this.getValueClass();
        CellType cellType = this.getCellType();
        Date date = null;
        if (cellType == CellType.STRING) {
            String value = this.getCell().getStringCellValue();
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy.MM.dd");
            try {
                date = sdf.parse(value);
            }
            catch (ParseException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        } else if (cellType == CellType.NUMERIC) {
            date = this.getCell().getDateCellValue();
        }
        if (null != date) {
            if (java.sql.Date.class.equals(clasz)) {
                return new java.sql.Date(date.getTime());
            }
            if (Timestamp.class.equals(clasz)) {
                return new Timestamp(date.getTime());
            }
        }
        return date;
    }

    public int getOrder() {
        return Integer.MAX_VALUE;
    }
}

