package com.bxm.component.office.excel.export.impl;

import com.bxm.component.office.excel.config.ExcelConstant;
import com.bxm.component.office.excel.export.setting.ExcelSheet;
import com.bxm.component.office.excel.export.setting.SheetHeader;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.springframework.util.ReflectionUtils;

import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;

/**
 * 功能说明：<br/>
 * 简单的Excel导出工具类，仅支持单行表头的导出，支持通过反射获取对象属性进行设置
 * <br/>
 * 开发时间：2016年3月2日<br/>
 */
@Component
@Scope(ConfigurableBeanFactory.SCOPE_PROTOTYPE)
public class SimpleExcelExporter extends AbstractExcelExport {

    @Override
    protected void execExport() {
        // 构建sheet
        createSheet();
    }

    /**
     * 构建excel sheet页，根据配置中的sheet集合进行构建
     */
    private void createSheet() {
        for (ExcelSheet sheet : setting.getSheets()) {
            newSheet(sheet);

            // 构建sheet标题行
            if (StringUtils.isNotBlank(sheet.getContentTitle())) {
                createTitle(sheet.getContentTitle(), sheet.getHeaders());
            }
            // 构建sheet表头
            createHeader(sheet.getHeaders());
            // 构建sheet主体内容
            createContent(sheet);
        }
    }

    /**
     * 构建标题当前sheet的标题行
     */
    private void createTitle(String title, List<SheetHeader> headers) {
        // 合并单元格
        int endCol = headers.size();
        newRow();
        setCellContent(title, 1, endCol, getTitleCellStyle());
    }

    /**
     * 构建sheet主体部分,根据设置的参数信息进行表格设置
     * <li>根据表头设置的field属性进行反射取值
     */
    private void createContent(ExcelSheet sheet) {
        if (null != sheet.getDataCollection()) {
            for (Object data : sheet.getDataCollection()) {
                newRow();

                for (SheetHeader header : sheet.getHeaders()) {
                    Object value = null;
                    try {
                        Field field = ReflectionUtils.findField(data.getClass(), header.getField());

                        if (null == field) {
                            LOGGER.info("[{}]对象中不存在[{}]", data.getClass(), header.getField());
                        } else {
                            ReflectionUtils.makeAccessible(field);
                            value = ReflectionUtils.getField(field, data);
                        }
                    } catch (Exception e) {
                        LOGGER.error("找不到" + header.getField() + "的值");
                    }

                    getContext().addExtend(ExcelConstant.EXPORT_HEADER, header);
                    setContentCellContent(value, header.getCellType());
                }
            }
        } else if (null != sheet.getDataMap()) {
            for (Map<String, Object> data : sheet.getDataMap()) {
                newRow();

                for (SheetHeader header : sheet.getHeaders()) {
                    Object value = data.get(header.getField());

                    getContext().addExtend(ExcelConstant.EXPORT_HEADER, header);
                    setContentCellContent(value, header.getCellType());
                }
            }
        }
    }
}
