package com.bxm.component.office.excel.export.setting;

import com.bxm.newidea.component.vo.BaseBean;
import com.google.common.collect.Lists;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 功能说明：<br/>
 * excel sheet导出参数
 * <br/>
 * 开发人员：liuj(liujia1@strongit.com.cn)<br/>
 * 开发时间：2016年3月1日<br/>
 */
public class ExcelSheet {

    /**
     * sheet tab处的标签显示标题
     */
    private String sheetName;

    /**
     * 当前sheet的表格显示标题
     */
    private String contentTitle;

    /**
     * 是否冻结标题部分（包括title和header）
     */
    private boolean freezeHeader;

    /**
     * 默认的列宽度,默认不予设置，当指定了值时才进行设置
     * 注意：宽度已经转换为字符宽度，即设置数字 * 256
     */
    private int defaultWidth;

    /**
     * 当前sheet页的表格表头
     */
    private List<SheetHeader> headers;

    /**
     * 内容部分的数据（集合类型,用于处理基础数据类型）
     */
    private Collection<? extends BaseBean> dataCollection;

    /**
     * excel内容部分数据（用于处理数据动态生成的情况）
     */
    private Collection<Map<String, Object>> dataMap;

    /**
     * 复杂excel表单数据，多个数据
     */
    private Map<String, Object> extendData;

    public Collection<Map<String, Object>> getDataMap() {
        return dataMap;
    }

    public ExcelSheet setDataMap(Collection<Map<String, Object>> dataMap) {
        this.dataMap = dataMap;
        return this;
    }

    public String getContentTitle() {
        return contentTitle;
    }

    public ExcelSheet setContentTitle(String contentTitle) {
        this.contentTitle = contentTitle;
        return this;
    }

    public List<SheetHeader> getHeaders() {
        if (null == headers) {
            headers = Lists.newArrayList();
        }
        return headers;
    }

    public ExcelSheet setHeaders(List<SheetHeader> headers) {
        this.headers = headers;
        return this;
    }

    public ExcelSheet addHeader(SheetHeader header) {
        if (null == headers) {
            headers = Lists.newArrayList();
        }
        headers.add(header);
        return this;
    }

    public String getSheetName() {
        return sheetName;
    }

    public ExcelSheet setSheetName(String sheetName) {
        this.sheetName = sheetName;
        return this;
    }

    public boolean isFreezeHeader() {
        return freezeHeader;
    }

    public ExcelSheet setFreezeHeader(boolean freezeHeader) {
        this.freezeHeader = freezeHeader;
        return this;
    }

    public int getDefaultWidth() {
        return defaultWidth;
    }

    public ExcelSheet setDefaultWidth(int defaultWidth) {
        this.defaultWidth = defaultWidth;
        return this;
    }

    public Collection<? extends BaseBean> getDataCollection() {
        return dataCollection;
    }

    public ExcelSheet setDataCollection(Collection<? extends BaseBean> dataCollection) {
        this.dataCollection = dataCollection;
        return this;
    }

    /**
     * 添加excel需要的扩展数据（具体为一个map，数据以key获取）
     * @param key    数据的key，在实现类中以该key获取对应数据
     * @param object 数据
     */
    public ExcelSheet addExtendData(String key, Object object) {
        if (extendData == null) {
            extendData = new HashMap<>();
        }
        extendData.put(key, object);
        return this;
    }

    /**
     * 根据设定的key获取excel数据
     * @param key
     * @return
     */
    public Object getExtendData(String key) {
        if (extendData == null) {
            return null;
        }
        return extendData.get(key);
    }

    /**
     * 扩展数据是否有值
     * @return
     */
    public boolean hasExtendData() {
        if (extendData == null) {
            return false;
        }
        return extendData.size() > 0;
    }

}
