package com.bxm.component.office.excel.export.themes.impl;

import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.VerticalAlignment;


public class TitleCellStyleCreaterImpl extends AbstractCellStyleCreater {

    @Override
    public CellStyle create() {
        CellStyle style = workbook.createCellStyle();

        //设置边框
        style.setBorderBottom(BorderStyle.THIN);
        style.setBorderLeft(BorderStyle.THIN);
        style.setBorderRight(BorderStyle.THIN);
        style.setBorderTop(BorderStyle.THIN);
        style.setAlignment(HorizontalAlignment.CENTER);
        style.setVerticalAlignment(VerticalAlignment.CENTER);

        //设置字体
        HSSFFont font = workbook.createFont();
        font.setBold(true);
        font.setFontName("隶书");
        font.setFontHeightInPoints((short) 18);
        style.setFont(font);

        return style;
    }

}
