/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.component.office.excel.export.themes;

import com.bxm.component.office.excel.export.themes.CellStyleCreater;
import com.bxm.component.office.excel.export.themes.impl.ContentCellStyleCreaterImpl;
import com.bxm.component.office.excel.export.themes.impl.HeadCellStyleCreaterImpl;
import com.bxm.component.office.excel.export.themes.impl.TitleCellStyleCreaterImpl;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.CellStyle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class ExcelThemesManage {
    private Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    private CellStyleCreater titleCellStyleCreater = new TitleCellStyleCreaterImpl();
    private CellStyleCreater headCellStyleCreater = new HeadCellStyleCreaterImpl();
    private CellStyleCreater contentCellStyleCreater = new ContentCellStyleCreaterImpl();
    private CellStyle titleStyle;
    private CellStyle headStyle;
    private CellStyle contentStyle;
    private boolean init;

    public void setTitleCellStyleCreater(CellStyleCreater titleCellStyleCreater) {
        this.titleCellStyleCreater = titleCellStyleCreater;
    }

    public void setHeadCellStyleCreater(CellStyleCreater headCellStyleCreater) {
        this.headCellStyleCreater = headCellStyleCreater;
    }

    public void setContentCellStyleCreater(CellStyleCreater contentCellStyleCreater) {
        this.contentCellStyleCreater = contentCellStyleCreater;
    }

    public void init(HSSFWorkbook workbook) {
        this.init = true;
        this.titleCellStyleCreater.setWorkbook(workbook);
        this.headCellStyleCreater.setWorkbook(workbook);
        this.contentCellStyleCreater.setWorkbook(workbook);
    }

    public CellStyle getTitleStyle() {
        this.assertInit();
        if (this.titleStyle == null) {
            this.titleStyle = this.titleCellStyleCreater.create();
        }
        return this.titleStyle;
    }

    public CellStyle getHeadStyle() {
        this.assertInit();
        if (this.headStyle == null) {
            this.headStyle = this.headCellStyleCreater.create();
        }
        return this.headStyle;
    }

    public CellStyle getContentStyle() {
        this.assertInit();
        if (this.contentStyle == null) {
            this.contentStyle = this.contentCellStyleCreater.create();
        }
        return this.contentStyle;
    }

    private void assertInit() {
        if (!this.init) {
            this.LOGGER.error("\u8bf7\u8c03\u7528ExcelThemesManage.init\u521d\u59cb\u5316");
        }
    }
}

