/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.component.oncejob.bootstrap;

import com.bxm.component.oncejob.bootstrap.JobHolder;
import com.bxm.component.oncejob.config.ComponentOnceJobConfigurationProperties;
import com.bxm.component.oncejob.job.JobPersistentObject;
import com.bxm.component.oncejob.storage.RecentJobRepository;
import com.bxm.newidea.component.tools.DateUtils;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FetchRecentJobRunner
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(FetchRecentJobRunner.class);
    private RecentJobRepository recentJobRepository;
    private ComponentOnceJobConfigurationProperties properties;

    @Override
    public void run() {
        long fixFetchMills = (System.currentTimeMillis() / (long)this.properties.getFetchIntervalMills() + 1L) * (long)this.properties.getFetchIntervalMills();
        try {
            List<JobPersistentObject> persistentObjects = this.recentJobRepository.load(fixFetchMills, this.properties.getMaxFetchNum());
            if (log.isDebugEnabled()) {
                log.debug("\u9884\u62c9\u53d6\u5b9a\u65f6\u4efb\u52a1\uff0c\u62c9\u53d6\u6570\u91cf\uff1a{},\u62c9\u53d6\u65f6\u95f4\uff1a{}", (Object)persistentObjects.size(), (Object)fixFetchMills);
            }
            if (persistentObjects.size() > 0) {
                for (JobPersistentObject persistentObject : persistentObjects) {
                    JobHolder.pushJob(persistentObject);
                }
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public static void main(String[] args) {
        long fixFetchMills = (System.currentTimeMillis() / 5000L + 1L) * 5000L;
        System.out.println(DateUtils.formatDateTime((Date)new Date(fixFetchMills)));
        System.out.println(fixFetchMills / 5000L);
    }

    public FetchRecentJobRunner(RecentJobRepository recentJobRepository, ComponentOnceJobConfigurationProperties properties) {
        this.recentJobRepository = recentJobRepository;
        this.properties = properties;
    }
}

