/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.component.oncejob.config;

import com.bxm.component.oncejob.enums.RepositoryStrategy;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="component.once-job")
public class ComponentOnceJobConfigurationProperties {
    private boolean enable = true;
    private final int fetchLongTermJobMills = 1800000;
    private final int fetchIntervalMills = 5000;
    private int clearDirtyIntervalMills = 30000;
    private int maxFetchNum = 100;
    private int longTermFetchPageSize = 1000;
    private long jobExpendWarningMills = 200L;
    @Value(value="${spring.application.name:undefined}")
    private String appName;
    private RepositoryStrategy recentJobRepository = RepositoryStrategy.MEMORY;
    private RepositoryStrategy longTermJobRepository = RepositoryStrategy.MEMORY;
    private ExecutorThreadPool executorPool = new ExecutorThreadPool();

    public boolean isEnable() {
        return this.enable;
    }

    public int getFetchLongTermJobMills() {
        return this.fetchLongTermJobMills;
    }

    public int getFetchIntervalMills() {
        return this.fetchIntervalMills;
    }

    public int getClearDirtyIntervalMills() {
        return this.clearDirtyIntervalMills;
    }

    public int getMaxFetchNum() {
        return this.maxFetchNum;
    }

    public int getLongTermFetchPageSize() {
        return this.longTermFetchPageSize;
    }

    public long getJobExpendWarningMills() {
        return this.jobExpendWarningMills;
    }

    public String getAppName() {
        return this.appName;
    }

    public RepositoryStrategy getRecentJobRepository() {
        return this.recentJobRepository;
    }

    public RepositoryStrategy getLongTermJobRepository() {
        return this.longTermJobRepository;
    }

    public ExecutorThreadPool getExecutorPool() {
        return this.executorPool;
    }

    public void setEnable(boolean enable) {
        this.enable = enable;
    }

    public void setClearDirtyIntervalMills(int clearDirtyIntervalMills) {
        this.clearDirtyIntervalMills = clearDirtyIntervalMills;
    }

    public void setMaxFetchNum(int maxFetchNum) {
        this.maxFetchNum = maxFetchNum;
    }

    public void setLongTermFetchPageSize(int longTermFetchPageSize) {
        this.longTermFetchPageSize = longTermFetchPageSize;
    }

    public void setJobExpendWarningMills(long jobExpendWarningMills) {
        this.jobExpendWarningMills = jobExpendWarningMills;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public void setRecentJobRepository(RepositoryStrategy recentJobRepository) {
        this.recentJobRepository = recentJobRepository;
    }

    public void setLongTermJobRepository(RepositoryStrategy longTermJobRepository) {
        this.longTermJobRepository = longTermJobRepository;
    }

    public void setExecutorPool(ExecutorThreadPool executorPool) {
        this.executorPool = executorPool;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ComponentOnceJobConfigurationProperties)) {
            return false;
        }
        ComponentOnceJobConfigurationProperties other = (ComponentOnceJobConfigurationProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isEnable() != other.isEnable()) {
            return false;
        }
        if (this.getFetchLongTermJobMills() != other.getFetchLongTermJobMills()) {
            return false;
        }
        if (this.getFetchIntervalMills() != other.getFetchIntervalMills()) {
            return false;
        }
        if (this.getClearDirtyIntervalMills() != other.getClearDirtyIntervalMills()) {
            return false;
        }
        if (this.getMaxFetchNum() != other.getMaxFetchNum()) {
            return false;
        }
        if (this.getLongTermFetchPageSize() != other.getLongTermFetchPageSize()) {
            return false;
        }
        if (this.getJobExpendWarningMills() != other.getJobExpendWarningMills()) {
            return false;
        }
        String this$appName = this.getAppName();
        String other$appName = other.getAppName();
        if (this$appName == null ? other$appName != null : !this$appName.equals(other$appName)) {
            return false;
        }
        RepositoryStrategy this$recentJobRepository = this.getRecentJobRepository();
        RepositoryStrategy other$recentJobRepository = other.getRecentJobRepository();
        if (this$recentJobRepository == null ? other$recentJobRepository != null : !((Object)((Object)this$recentJobRepository)).equals((Object)other$recentJobRepository)) {
            return false;
        }
        RepositoryStrategy this$longTermJobRepository = this.getLongTermJobRepository();
        RepositoryStrategy other$longTermJobRepository = other.getLongTermJobRepository();
        if (this$longTermJobRepository == null ? other$longTermJobRepository != null : !((Object)((Object)this$longTermJobRepository)).equals((Object)other$longTermJobRepository)) {
            return false;
        }
        ExecutorThreadPool this$executorPool = this.getExecutorPool();
        ExecutorThreadPool other$executorPool = other.getExecutorPool();
        return !(this$executorPool == null ? other$executorPool != null : !((Object)this$executorPool).equals(other$executorPool));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ComponentOnceJobConfigurationProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isEnable() ? 79 : 97);
        result = result * 59 + this.getFetchLongTermJobMills();
        result = result * 59 + this.getFetchIntervalMills();
        result = result * 59 + this.getClearDirtyIntervalMills();
        result = result * 59 + this.getMaxFetchNum();
        result = result * 59 + this.getLongTermFetchPageSize();
        long $jobExpendWarningMills = this.getJobExpendWarningMills();
        result = result * 59 + (int)($jobExpendWarningMills >>> 32 ^ $jobExpendWarningMills);
        String $appName = this.getAppName();
        result = result * 59 + ($appName == null ? 43 : $appName.hashCode());
        RepositoryStrategy $recentJobRepository = this.getRecentJobRepository();
        result = result * 59 + ($recentJobRepository == null ? 43 : ((Object)((Object)$recentJobRepository)).hashCode());
        RepositoryStrategy $longTermJobRepository = this.getLongTermJobRepository();
        result = result * 59 + ($longTermJobRepository == null ? 43 : ((Object)((Object)$longTermJobRepository)).hashCode());
        ExecutorThreadPool $executorPool = this.getExecutorPool();
        result = result * 59 + ($executorPool == null ? 43 : ((Object)$executorPool).hashCode());
        return result;
    }

    public String toString() {
        return "ComponentOnceJobConfigurationProperties(enable=" + this.isEnable() + ", fetchLongTermJobMills=" + this.getFetchLongTermJobMills() + ", fetchIntervalMills=" + this.getFetchIntervalMills() + ", clearDirtyIntervalMills=" + this.getClearDirtyIntervalMills() + ", maxFetchNum=" + this.getMaxFetchNum() + ", longTermFetchPageSize=" + this.getLongTermFetchPageSize() + ", jobExpendWarningMills=" + this.getJobExpendWarningMills() + ", appName=" + this.getAppName() + ", recentJobRepository=" + (Object)((Object)this.getRecentJobRepository()) + ", longTermJobRepository=" + (Object)((Object)this.getLongTermJobRepository()) + ", executorPool=" + this.getExecutorPool() + ")";
    }

    public static class ExecutorThreadPool {
        private int coreSize = 5;
        private int maxSize = 50;
        private int queueSize = 1000;

        public int getCoreSize() {
            return this.coreSize;
        }

        public int getMaxSize() {
            return this.maxSize;
        }

        public int getQueueSize() {
            return this.queueSize;
        }

        public void setCoreSize(int coreSize) {
            this.coreSize = coreSize;
        }

        public void setMaxSize(int maxSize) {
            this.maxSize = maxSize;
        }

        public void setQueueSize(int queueSize) {
            this.queueSize = queueSize;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ExecutorThreadPool)) {
                return false;
            }
            ExecutorThreadPool other = (ExecutorThreadPool)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getCoreSize() != other.getCoreSize()) {
                return false;
            }
            if (this.getMaxSize() != other.getMaxSize()) {
                return false;
            }
            return this.getQueueSize() == other.getQueueSize();
        }

        protected boolean canEqual(Object other) {
            return other instanceof ExecutorThreadPool;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getCoreSize();
            result = result * 59 + this.getMaxSize();
            result = result * 59 + this.getQueueSize();
            return result;
        }

        public String toString() {
            return "ComponentOnceJobConfigurationProperties.ExecutorThreadPool(coreSize=" + this.getCoreSize() + ", maxSize=" + this.getMaxSize() + ", queueSize=" + this.getQueueSize() + ")";
        }
    }
}

