package com.bxm.component.oncejob.constant;

import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.impl.DefaultKeyGenerator;
import lombok.experimental.UtilityClass;

/**
 * @author liujia
 * @date 7/29/21 8:02 PM
 **/
@UtilityClass
public class OnceJobRedisKey {

    /**
     * 短期任务分片存储
     */
    public static KeyGenerator JOB_FRAGMENT_KEY = DefaultKeyGenerator.build("component", "job", "fragment");

    /**
     * 短期任务的分片
     */
    public static KeyGenerator JOB_FRAGMENT_INDEX_KEY = DefaultKeyGenerator.build("component", "job", "fragment").copy().appendKey("index");

    public static KeyGenerator JOB_RECENT_DIRTY_LOCK_KEY = DefaultKeyGenerator.build("component", "job", "fragment").copy().appendKey("dirty");

    /**
     * 获取任务分片的分布式锁
     */
    public static KeyGenerator JOB_FRAGMENT_INDEX_LOCK_KEY = DefaultKeyGenerator.build("component", "job", "fragment").copy().appendKey("lock");

    /**
     * 长期存储的任务
     */
    public static KeyGenerator JOB_LONG_TERM_KEY = DefaultKeyGenerator.build("component", "job", "long");

    /**
     * 长期存储的索引信息，用于判断是否存在未处理的历史人物
     */
    public static KeyGenerator JOB_LONG_TERM_INDEX_KEY = DefaultKeyGenerator.build("component", "job", "long").copy().appendKey("index");

    /**
     * 清理历史任务的分布式锁，防止多实例同时处理
     */
    public static KeyGenerator JOB_LONG_TERM_DIRTY_LOCK_KEY = DefaultKeyGenerator.build("component", "job", "dirty").copy().appendKey("lock");

    /**
     * 长期存储任务的拉取对应的分布式锁，防止多实例竞争
     */
    public static KeyGenerator JOB_LONG_TERM_LOCK_KEY = DefaultKeyGenerator.build("component", "job", "long").copy().appendKey("lock");
}
