package com.bxm.component.oncejob.converter;

import com.bxm.component.oncejob.job.JobPersistentObject;
import com.bxm.component.oncejob.job.OnceJobDefinition;
import com.bxm.component.oncejob.utils.JobIdUtil;
import com.bxm.newidea.component.JSON;
import lombok.experimental.UtilityClass;

/**
 * @author liujia
 * @date 7/29/21 8:04 PM
 **/
@UtilityClass
public class JobConverter {

    public static JobPersistentObject convert(OnceJobDefinition definition) {
        JobPersistentObject persistentObject = new JobPersistentObject();
        persistentObject.setCallbackClassName(definition.getCallback().getClass().getName());
        persistentObject.setFireDate(definition.getFireDate().getTime());
        persistentObject.setParamJson(JSON.toJSONString(definition.getParam()));
        persistentObject.setMissFireStrategy(definition.getMissFire().name());
        persistentObject.setJobId(JobIdUtil.buildJobId(persistentObject));

        return persistentObject;
    }
}
