package com.bxm.newidea.component.payment.service.impl;

import com.bxm.newidea.component.payment.enums.PaymentActionEnum;
import com.bxm.newidea.component.payment.enums.PaymentModeEnum;
import com.bxm.newidea.component.payment.enums.PaymentPlatformEnum;
import com.bxm.newidea.component.payment.request.WechatJsapiPreOrderPaymentRequest;
import com.bxm.newidea.component.payment.response.WechatJsapiPreOrderPaymentResponse;
import com.bxm.newidea.component.payment.service.IPaymentAction;
import com.bxm.newidea.component.wechat.service.WechatMpService;
import com.github.binarywang.wxpay.bean.order.WxPayMpOrderResult;
import com.github.binarywang.wxpay.bean.request.BaseWxPayRequest;
import com.github.binarywang.wxpay.bean.request.WxPayUnifiedOrderRequest;
import com.github.binarywang.wxpay.constant.WxPayConstants;
import com.github.binarywang.wxpay.exception.WxPayException;
import com.github.binarywang.wxpay.service.WxPayService;
import lombok.extern.slf4j.Slf4j;
import me.chanjar.weixin.mp.bean.result.WxMpUser;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * 微信JS-API创建预支付订单
 *
 * @author liujia
 */
@Component
@Slf4j
public class WechatJsapiPreOrderAction extends BasePaymentAction implements IPaymentAction<WechatJsapiPreOrderPaymentRequest, WechatJsapiPreOrderPaymentResponse> {

    @Autowired
    private WechatMpService wechatMpService;

    @SuppressWarnings("Duplicates")
    @Override
    public WechatJsapiPreOrderPaymentResponse exec(WechatJsapiPreOrderPaymentRequest request) {
        WxMpUser wxMpUser = wechatMpService.exchangeWxMapUser(request.getScene(), request.getWxMpAuthCode());
        if (null == wxMpUser) {
            log.error("请检查：1.scnen配置的商户号与公众号是否绑定，2：授权码是否正确，scnen为：{}，授权码为：{}",
                    request.getScene(),
                    request.getWxMpAuthCode());
            return null;
        }

        WxPayService wxPayService = configContext.obtainWxPayService(request.getScene());

        if (wxPayService == null) {
            return null;
        }

        // TODO 【liujia】验证请求地址是否在配置的安全域名中

        WxPayUnifiedOrderRequest wxPayUnifiedOrderRequest = new WxPayUnifiedOrderRequest();

        wxPayUnifiedOrderRequest.setDeviceInfo("WEB");
        wxPayUnifiedOrderRequest.setOutTradeNo(request.getOrderNum());
        wxPayUnifiedOrderRequest.setBody(request.getOrderDescription());
        wxPayUnifiedOrderRequest.setTotalFee(BaseWxPayRequest.yuanToFen(request.getAmount().toString()));
        wxPayUnifiedOrderRequest.setSpbillCreateIp(request.getRequestIp());
        wxPayUnifiedOrderRequest.setTradeType(WxPayConstants.TradeType.JSAPI);
        wxPayUnifiedOrderRequest.setOpenid(wxMpUser.getOpenId());

        try {
            WxPayMpOrderResult wxPayMpOrderResult = wxPayService.createOrder(wxPayUnifiedOrderRequest);

            WechatJsapiPreOrderPaymentResponse response = new WechatJsapiPreOrderPaymentResponse();
            response.setAppId(wxPayMpOrderResult.getAppId());
            response.setNonceStr(wxPayMpOrderResult.getNonceStr());
            response.setPackageValue(wxPayMpOrderResult.getPackageValue());
            response.setPaySign(wxPayMpOrderResult.getPaySign());
            response.setSignType(wxPayMpOrderResult.getSignType());
            response.setTimeStamp(wxPayMpOrderResult.getTimeStamp());

            return response;
        } catch (WxPayException e) {
            log.error("创建预支付订单失败，请求参数为：{}", request);
            log.error(e.getMessage(), e);
            return null;
        }
    }

    @Override
    public PaymentPlatformEnum matchPlatform() {
        return PaymentPlatformEnum.WECHAT;
    }

    @Override
    public PaymentActionEnum matchAction() {
        return PaymentActionEnum.PRE_PAYMENT;
    }

    @Override
    public PaymentModeEnum matchMode() {
        return PaymentModeEnum.JSAPI;
    }
}
