package com.bxm.component.poster.utils;

import com.bxm.component.httpclient.utils.OkHttpUtils;
import com.bxm.newidea.component.tools.StringUtils;
import lombok.SneakyThrows;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.io.FileUtils;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

import static com.bxm.newidea.component.tools.FileUtils.*;

/**
 * @author liujia
 * @date 12/17/20 2:36 PM
 **/
@Slf4j
public class FileLoadUtil {

    /**
     * 加载文件，支持加载本地文件与远程文件
     *
     * @param filePath 文件路径，本地路径或者远程网络地址
     * @param cache    如果是远程网络文件，是否缓存到本地
     * @return 文件输入流
     */
    @SneakyThrows
    public static InputStream load(String filePath, boolean cache) {
        File loadFile = loadFile(filePath, cache);

        if (null != loadFile) {
            return new FileInputStream(loadFile);
        }

        return null;
    }

    private static String buildLocalPath(String remotePath) {
        long hashCode = remotePath.hashCode();
        String fileExtension = getFilextension(remotePath);
        return getClassRootPath() + (hashCode % 100) + File.separator + hashCode + "." + fileExtension;
    }

    private static boolean isRemote(String filePath) {
        return StringUtils.startsWithAny(filePath, "http:", "https:");
    }

    /**
     * 加载本地文件
     *
     * @param filePath 文件路径，本地路径或者远程网络地址
     * @param cache    如果是远程网络文件，是否缓存到本地
     * @return 文件地址对应的文件
     */
    public static File loadFile(String filePath, boolean cache) {
        File localFile;

        if (isRemote(filePath)) {
            String localPath = buildLocalPath(filePath);
            localFile = new File(localPath);

            if (cache && localFile.exists()) {
                return localFile;
            }

            OkHttpUtils.download(filePath, (response) -> {
                if (response.body() != null) {
                    try {
                        checkAndCreateFile(localFile);
                        FileUtils.writeByteArrayToFile(localFile, response.body().bytes());
                    } catch (IOException e) {
                        log.error(e.getMessage(), e);
                    }
                }
            });
        } else {
            localFile = new File(filePath);

            if (!localFile.exists()) {
                return null;
            }

        }
        return localFile;
    }
}