package com.bxm.newidea.component.redis.impl;

import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.tools.StringUtils;
import lombok.extern.slf4j.Slf4j;

import java.util.Objects;

/**
 * 默认的key值创建器
 *
 * @author liujia 2018/5/21 15:27
 */
@Slf4j
public class DefaultKeyGenerator implements KeyGenerator {

    private String module;

    private String group;

    private String key;

    private boolean copyObj;

    private DefaultKeyGenerator(String module, String group, String key) {
        this.setGroup(group).setModule(module).setKey(key);
    }

    private DefaultKeyGenerator(String module, String group) {
        this.setGroup(group).setModule(module);
    }

    private DefaultKeyGenerator() {
    }

    public static DefaultKeyGenerator build() {
        return new DefaultKeyGenerator();
    }

    public static DefaultKeyGenerator build(String module, String group) {
        return new DefaultKeyGenerator(module, group);
    }

    public static DefaultKeyGenerator build(String module, String group, String key) {
        return new DefaultKeyGenerator(module, group, key);
    }

    private static DefaultKeyGenerator build(DefaultKeyGenerator key) {
        return new DefaultKeyGenerator(key.module, key.group, key.key);
    }

    @Override
    public DefaultKeyGenerator setModule(String module) {
        this.module = module;
        return this;
    }

    @Override
    public DefaultKeyGenerator setGroup(String group) {
        this.group = group;
        return this;
    }

    @Override
    public DefaultKeyGenerator setKey(String key) {
        this.key = key;
        return this;
    }

    String getKey() {
        return this.key;
    }

    boolean isCopyObj() {
        return copyObj;
    }

    void setCopyObj(boolean copyObj) {
        this.copyObj = copyObj;
    }

    @Override
    public DefaultKeyGenerator appendKey(Object subKey) {
        DefaultKeyGenerator generator;
        if (this.isCopyObj()) {
            generator = this;
        } else {
            log.error("{}:未调用#copy()方法，创建了新对象，请注意接收返回值", toString());
            generator = copy();
        }

        if (Objects.isNull(subKey)) {
            return generator;
        }

        if (StringUtils.isBlank(generator.getKey())) {
            generator.setKey(subKey.toString());
        } else {
            generator.setKey(generator.getKey() + JOIN_CHAR + subKey.toString());
        }
        return generator;
    }

    @Override
    public String gen() {
        String redisKey = this.module + JOIN_CHAR + this.group + JOIN_CHAR + this.key;

        if (redisKey.length() > MAX_KEY_LENGTH) {
            log.error("缓存键值设计过长，请缩短实际保存的键，使用变量名来保证可阅读性,键：{}", redisKey);
        }

        return redisKey;
    }

    @Override
    public DefaultKeyGenerator copy() {
        DefaultKeyGenerator keyGenerator = DefaultKeyGenerator.build(this);
        keyGenerator.setCopyObj(true);
        return keyGenerator;
    }

    @Override
    public String toString() {
        return gen();
    }
}
