/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.component.redisson.impl;

import com.bxm.newidea.component.JSON;
import com.bxm.newidea.component.redis.BaseRedisOperation;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redisson.config.SwitchMultiDataSourceHandler;
import com.bxm.newidea.component.tools.ReflectionUtils;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.google.common.collect.Lists;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

class BaseRedisAdapter
implements BaseRedisOperation {
    private static final Logger log = LoggerFactory.getLogger(BaseRedisAdapter.class);
    SwitchMultiDataSourceHandler switchMultiDataSourceHandler;

    BaseRedisAdapter(SwitchMultiDataSourceHandler switchMultiDataSourceHandler) {
        this.switchMultiDataSourceHandler = switchMultiDataSourceHandler;
    }

    public Boolean remove(KeyGenerator key) {
        return this.switchMultiDataSourceHandler.getRedissonClient(key.getDbName()).getBucket(key.gen()).delete();
    }

    public Long remove(List<KeyGenerator> keys) {
        if (CollectionUtils.isEmpty(keys)) {
            return 0L;
        }
        AtomicLong deleteNum = new AtomicLong();
        keys.forEach(keyGenerator -> {
            boolean delete = this.switchMultiDataSourceHandler.getRedissonClient(keyGenerator.getDbName()).getBucket(keyGenerator.gen()).delete();
            deleteNum.addAndGet(delete ? 1L : 0L);
        });
        return deleteNum.get();
    }

    public void expire(KeyGenerator key, long seconds) {
        if (seconds > 0L) {
            this.switchMultiDataSourceHandler.getRedissonClient(key.getDbName()).getBucket(key.gen()).expire(seconds, TimeUnit.SECONDS);
        }
    }

    public void expire(KeyGenerator key, Date expiredDate) {
        if (null != expiredDate) {
            long expireTime = expiredDate.getTime() - System.currentTimeMillis();
            this.switchMultiDataSourceHandler.getRedissonClient(key.getDbName()).getBucket(key.gen()).expire(expireTime, TimeUnit.MILLISECONDS);
        }
    }

    public Boolean hasKey(KeyGenerator key) {
        return this.switchMultiDataSourceHandler.getRedissonClient(key.getDbName()).getBucket(key.gen()).isExists();
    }

    String serializerString(Object object) {
        if (ReflectionUtils.isPrimitiveType(object.getClass()) || ReflectionUtils.isNumeric(object.getClass())) {
            return object.toString();
        }
        return JSON.toJSONString((Object)object);
    }

    <T> T deSerializerString(String object, Class<T> clasz, TypeReference<T> typeReference) {
        if (clasz != null) {
            if (BaseRedisAdapter.getJavaType(String.class).equals((Object)BaseRedisAdapter.getJavaType(clasz))) {
                return (T)object;
            }
            return (T)JSON.parseObject((String)object, clasz);
        }
        Type type = typeReference.getType();
        TypeReference<String> stringTypeReference = new TypeReference<String>(){};
        if (stringTypeReference.getType().equals(type)) {
            return (T)object;
        }
        return (T)JSON.parseObject((String)object, typeReference);
    }

    protected static <T> JavaType getJavaType(Class<?> clazz) {
        return TypeFactory.defaultInstance().constructType(clazz);
    }

    List<String> convertKeys(KeyGenerator ... generators) {
        if (ArrayUtils.isEmpty((Object[])generators)) {
            return Lists.newArrayList();
        }
        ArrayList<String> keys = new ArrayList<String>();
        for (KeyGenerator generator : generators) {
            keys.add(generator.gen());
        }
        return keys;
    }

    List<String> convertKeysNotFirst(KeyGenerator ... generators) {
        if (ArrayUtils.isEmpty((Object[])generators)) {
            return Lists.newArrayList();
        }
        ArrayList<String> keys = new ArrayList<String>();
        for (int i = 0; i < generators.length; ++i) {
            if (i == 0) continue;
            keys.add(generators[i].gen());
        }
        return keys;
    }

    List<String> convertKeys(KeyGenerator keyGenerator, KeyGenerator ... generators) {
        if (ArrayUtils.isEmpty((Object[])generators)) {
            return Lists.newArrayList();
        }
        ArrayList<String> keys = new ArrayList<String>();
        keys.add(keyGenerator.gen());
        for (KeyGenerator generator : generators) {
            keys.add(generator.gen());
        }
        return keys;
    }

    public void rename(KeyGenerator oldKey, KeyGenerator newKey) {
        if (Objects.isNull(oldKey) || Objects.isNull(newKey)) {
            return;
        }
        this.switchMultiDataSourceHandler.getRedissonClient(oldKey.getDbName()).getBucket(oldKey.gen()).rename(newKey.gen());
    }
}

