/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.component.redisson.config;

import com.bxm.newidea.component.redis.DistributedLock;
import com.bxm.newidea.component.redis.HyperLogLogAdapter;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.bxm.newidea.component.redis.RedisListAdapter;
import com.bxm.newidea.component.redis.RedisSetAdapter;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.redis.RedisZSetAdapter;
import com.bxm.newidea.component.redisson.config.RedisClientRegister;
import com.bxm.newidea.component.redisson.config.RedissonConfigurationProperties;
import com.bxm.newidea.component.redisson.config.SwitchMultiDataSourceHandler;
import com.bxm.newidea.component.redisson.impl.HyperLogLogAdapterImpl;
import com.bxm.newidea.component.redisson.impl.RedissonDistributedLockImpl;
import com.bxm.newidea.component.redisson.impl.RedissonHashMapAdapterImpl;
import com.bxm.newidea.component.redisson.impl.RedissonListAdapterImpl;
import com.bxm.newidea.component.redisson.impl.RedissonSetAdapterImpl;
import com.bxm.newidea.component.redisson.impl.RedissonStringAdapterImpl;
import com.bxm.newidea.component.redisson.impl.RedissonZSetAdapterImpl;
import com.bxm.newidea.component.redisson.utils.RateLimiterFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={RedissonConfigurationProperties.class})
@ConditionalOnProperty(value={"component.redisson.type", "component.redisson.address"})
@Import(value={RedisClientRegister.class})
public class ComponentRedissonConfiguration {
    private static final Logger log = LoggerFactory.getLogger(ComponentRedissonConfiguration.class);
    private ApplicationContext applicationContext;
    private RedissonConfigurationProperties properties;

    public ComponentRedissonConfiguration(ApplicationContext applicationContext, RedissonConfigurationProperties properties) {
        this.applicationContext = applicationContext;
        this.properties = properties;
    }

    @Bean
    public SwitchMultiDataSourceHandler switchMultiDataSourceHandler() {
        return new SwitchMultiDataSourceHandler(this.applicationContext);
    }

    @Bean
    public HyperLogLogAdapter hyperLogLogAdapter(SwitchMultiDataSourceHandler client) {
        return new HyperLogLogAdapterImpl(client);
    }

    @Bean
    public DistributedLock distributedLock(SwitchMultiDataSourceHandler client) {
        return new RedissonDistributedLockImpl(client, this.properties);
    }

    @Bean
    public RedisHashMapAdapter redisHashMapAdapter(SwitchMultiDataSourceHandler client) {
        return new RedissonHashMapAdapterImpl(client);
    }

    @Bean
    public RedisListAdapter redisListAdapter(SwitchMultiDataSourceHandler client) {
        return new RedissonListAdapterImpl(client);
    }

    @Bean
    public RedisSetAdapter redisSetAdapter(SwitchMultiDataSourceHandler client) {
        return new RedissonSetAdapterImpl(client);
    }

    @Bean
    public RedisStringAdapter redisStringAdapter(SwitchMultiDataSourceHandler client) {
        return new RedissonStringAdapterImpl(client, this.properties);
    }

    @Bean
    public RedisZSetAdapter redisZSetAdapter(SwitchMultiDataSourceHandler client) {
        return new RedissonZSetAdapterImpl(client);
    }

    @Bean
    public RateLimiterFactory rateLimiterFactory(DistributedLock distributedLock, RedisStringAdapter redisStringAdapter) {
        return new RateLimiterFactory(distributedLock, redisStringAdapter);
    }
}

