/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.component.redisson.config;

import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

public class SwitchMultiDataSourceHandler {
    private static final Logger log = LoggerFactory.getLogger(SwitchMultiDataSourceHandler.class);
    private final ApplicationContext applicationContext;
    private static Map<String, RedissonClient> cacheRedissonClientMap = new ConcurrentHashMap<String, RedissonClient>();

    public SwitchMultiDataSourceHandler(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public RedissonClient getRedissonClient(String dbName) {
        RedissonClient targetRedissonClient = cacheRedissonClientMap.get(dbName);
        if (Objects.nonNull(targetRedissonClient)) {
            return targetRedissonClient;
        }
        targetRedissonClient = (RedissonClient)this.applicationContext.getBean(dbName + "RedissonDataSource", RedissonClient.class);
        if (Objects.nonNull(targetRedissonClient)) {
            cacheRedissonClientMap.put(dbName, targetRedissonClient);
            return targetRedissonClient;
        }
        RedissonClient defaultRedissonClient = cacheRedissonClientMap.get(dbName);
        if (Objects.nonNull(defaultRedissonClient)) {
            return defaultRedissonClient;
        }
        targetRedissonClient = (RedissonClient)this.applicationContext.getBean("defaultRedissonDataSource", RedissonClient.class);
        if (Objects.nonNull(targetRedissonClient)) {
            cacheRedissonClientMap.put("default", targetRedissonClient);
            return targetRedissonClient;
        }
        log.error("\u672a\u8bbe\u7f6eRedisson\u9ed8\u8ba4\u6570\u636e\u6e90\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e\uff01");
        return targetRedissonClient;
    }
}

