/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.component.redisson.impl;

import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisSetAdapter;
import com.bxm.newidea.component.redisson.config.SwitchMultiDataSourceHandler;
import com.bxm.newidea.component.redisson.impl.BaseRedisAdapter;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.collect.Lists;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.redisson.api.RSet;

public class RedissonSetAdapterImpl
extends BaseRedisAdapter
implements RedisSetAdapter {
    public RedissonSetAdapterImpl(SwitchMultiDataSourceHandler switchMultiDataSourceHandler) {
        super(switchMultiDataSourceHandler);
    }

    private RSet setOperations(KeyGenerator generator) {
        return this.switchMultiDataSourceHandler.getRedissonClient(generator.getDbName()).getSet(generator.gen());
    }

    public Long add(KeyGenerator generator, Object ... values) {
        AtomicLong deleteNum = new AtomicLong();
        for (Object value : values) {
            boolean add = this.setOperations(generator).add((Object)this.serializerString(value));
            deleteNum.addAndGet(add ? 1L : 0L);
        }
        return deleteNum.get();
    }

    public <T> Long remove(KeyGenerator generator, Object ... values) {
        AtomicLong deleteNum = new AtomicLong();
        for (Object value : values) {
            boolean add = this.setOperations(generator).remove((Object)this.serializerString(value));
            deleteNum.addAndGet(add ? 1L : 0L);
        }
        return deleteNum.get();
    }

    public <T> Boolean exists(KeyGenerator generator, T value) {
        return this.setOperations(generator).contains((Object)this.serializerString(value));
    }

    public <T> List<T> pop(KeyGenerator generator, Long count, Class<T> clasz) {
        Set result = this.setOperations(generator).removeRandom(count.intValue());
        List<Object> finalResult = Lists.newArrayList();
        if (result != null) {
            finalResult = result.stream().map(value -> this.deSerializerString((String)value, clasz, null)).collect(Collectors.toList());
        }
        return finalResult;
    }

    public <T> List<T> pop(KeyGenerator generator, Long count, TypeReference<T> typeReference) {
        Set result = this.setOperations(generator).removeRandom(count.intValue());
        List<Object> finalResult = Lists.newArrayList();
        if (result != null) {
            finalResult = result.stream().map(value -> this.deSerializerString((String)value, null, typeReference)).collect(Collectors.toList());
        }
        return finalResult;
    }

    public Long size(KeyGenerator generator) {
        return this.setOperations(generator).size();
    }

    public <T> Set<T> getAllMembers(KeyGenerator generator, Class<T> clasz) {
        return this.innerGetAllMemers(generator, clasz, null);
    }

    public <T> Set<T> getAllMembers(KeyGenerator generator, TypeReference<T> typeReference) {
        return this.innerGetAllMemers(generator, null, typeReference);
    }

    private <T> Set<T> innerGetAllMemers(KeyGenerator generator, Class<T> clasz, TypeReference<T> typeReference) {
        Set set = this.setOperations(generator).readAll();
        HashSet<T> result = new HashSet<T>();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            result.add(this.deSerializerString((String)iterator.next(), clasz, typeReference));
        }
        return result;
    }

    public <T> Set<T> difference(KeyGenerator generator, Class<T> clasz, KeyGenerator ... otherGenerators) {
        Set set = this.setOperations(generator).readDiff((String[])this.convertKeys(otherGenerators).stream().toArray(String[]::new));
        HashSet<T> result = new HashSet<T>();
        for (String s : set) {
            result.add(this.deSerializerString(s, clasz, null));
        }
        return result;
    }

    public Long differenceAndStore(KeyGenerator storeGenerator, KeyGenerator generator, KeyGenerator ... otherGenerators) {
        if (storeGenerator == null) {
            return 0L;
        }
        Set set = this.setOperations(generator).readDiff((String[])this.convertKeys(otherGenerators).stream().toArray(String[]::new));
        AtomicLong deleteNum = new AtomicLong();
        for (String value : set) {
            boolean add = this.setOperations(storeGenerator).add((Object)value);
            deleteNum.addAndGet(add ? 1L : 0L);
        }
        return deleteNum.get();
    }

    public <T> Set<T> inter(KeyGenerator generator, Class<T> clasz, KeyGenerator ... otherGenerators) {
        Set set = this.setOperations(generator).readIntersection((String[])this.convertKeys(otherGenerators).stream().toArray(String[]::new));
        HashSet<T> result = new HashSet<T>();
        for (String s : set) {
            result.add(this.deSerializerString(s, clasz, null));
        }
        return result;
    }

    public Long interAndStore(KeyGenerator storeGenerator, KeyGenerator generator, KeyGenerator ... otherGenerators) {
        if (storeGenerator == null) {
            return 0L;
        }
        Set set = this.setOperations(generator).readIntersection((String[])this.convertKeys(otherGenerators).stream().toArray(String[]::new));
        AtomicLong deleteNum = new AtomicLong();
        for (String value : set) {
            boolean add = this.setOperations(storeGenerator).add((Object)value);
            deleteNum.addAndGet(add ? 1L : 0L);
        }
        return deleteNum.get();
    }

    public <T> Set<T> union(KeyGenerator generator, Class<T> clasz, KeyGenerator ... otherGenerators) {
        Set set = this.setOperations(generator).readUnion((String[])this.convertKeys(otherGenerators).stream().toArray(String[]::new));
        HashSet<T> result = new HashSet<T>();
        for (String s : set) {
            result.add(this.deSerializerString(s, clasz, null));
        }
        return result;
    }

    public Long unionAndStore(KeyGenerator storeGenerator, KeyGenerator generator, KeyGenerator ... otherGenerators) {
        if (storeGenerator == null) {
            return 0L;
        }
        Set set = this.setOperations(generator).readUnion((String[])this.convertKeys(otherGenerators).stream().toArray(String[]::new));
        AtomicLong deleteNum = new AtomicLong();
        for (String value : set) {
            boolean add = this.setOperations(storeGenerator).add((Object)value);
            deleteNum.addAndGet(add ? 1L : 0L);
        }
        return deleteNum.get();
    }

    public <T> Boolean move(KeyGenerator sourceKey, KeyGenerator targetKey, T item, Class<T> clasz) {
        return this.setOperations(sourceKey).move(targetKey.gen(), (Object)this.serializerString(item));
    }
}

