/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.component.redisson.utils;

import java.util.concurrent.TimeUnit;

public class RedisPermits {
    private Long maxPermits;
    private Long storedPermits;
    private Long intervalMillis;
    private Long nextFreeTicketMillis;

    public RedisPermits() {
    }

    public RedisPermits(Double permitsPerSecond, Integer maxBurstSeconds) {
        if (null == maxBurstSeconds) {
            maxBurstSeconds = 60;
        }
        this.maxPermits = (long)(permitsPerSecond * (double)maxBurstSeconds.intValue());
        this.storedPermits = permitsPerSecond.longValue();
        this.intervalMillis = (long)((double)TimeUnit.SECONDS.toMillis(1L) / permitsPerSecond);
        this.nextFreeTicketMillis = System.currentTimeMillis();
    }

    public long expires() {
        long now = System.currentTimeMillis();
        return 2L * TimeUnit.MINUTES.toSeconds(1L) + TimeUnit.MILLISECONDS.toSeconds(Math.max(this.nextFreeTicketMillis, now) - now);
    }

    public boolean reSync(long now) {
        if (now > this.nextFreeTicketMillis) {
            this.storedPermits = Math.min(this.maxPermits, this.storedPermits + (now - this.nextFreeTicketMillis) / this.intervalMillis);
            this.nextFreeTicketMillis = now;
            return true;
        }
        return false;
    }

    public Long getMaxPermits() {
        return this.maxPermits;
    }

    public Long getStoredPermits() {
        return this.storedPermits;
    }

    public Long getIntervalMillis() {
        return this.intervalMillis;
    }

    public Long getNextFreeTicketMillis() {
        return this.nextFreeTicketMillis;
    }

    public void setMaxPermits(Long maxPermits) {
        this.maxPermits = maxPermits;
    }

    public void setStoredPermits(Long storedPermits) {
        this.storedPermits = storedPermits;
    }

    public void setIntervalMillis(Long intervalMillis) {
        this.intervalMillis = intervalMillis;
    }

    public void setNextFreeTicketMillis(Long nextFreeTicketMillis) {
        this.nextFreeTicketMillis = nextFreeTicketMillis;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RedisPermits)) {
            return false;
        }
        RedisPermits other = (RedisPermits)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$maxPermits = this.getMaxPermits();
        Long other$maxPermits = other.getMaxPermits();
        if (this$maxPermits == null ? other$maxPermits != null : !((Object)this$maxPermits).equals(other$maxPermits)) {
            return false;
        }
        Long this$storedPermits = this.getStoredPermits();
        Long other$storedPermits = other.getStoredPermits();
        if (this$storedPermits == null ? other$storedPermits != null : !((Object)this$storedPermits).equals(other$storedPermits)) {
            return false;
        }
        Long this$intervalMillis = this.getIntervalMillis();
        Long other$intervalMillis = other.getIntervalMillis();
        if (this$intervalMillis == null ? other$intervalMillis != null : !((Object)this$intervalMillis).equals(other$intervalMillis)) {
            return false;
        }
        Long this$nextFreeTicketMillis = this.getNextFreeTicketMillis();
        Long other$nextFreeTicketMillis = other.getNextFreeTicketMillis();
        return !(this$nextFreeTicketMillis == null ? other$nextFreeTicketMillis != null : !((Object)this$nextFreeTicketMillis).equals(other$nextFreeTicketMillis));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RedisPermits;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $maxPermits = this.getMaxPermits();
        result = result * 59 + ($maxPermits == null ? 43 : ((Object)$maxPermits).hashCode());
        Long $storedPermits = this.getStoredPermits();
        result = result * 59 + ($storedPermits == null ? 43 : ((Object)$storedPermits).hashCode());
        Long $intervalMillis = this.getIntervalMillis();
        result = result * 59 + ($intervalMillis == null ? 43 : ((Object)$intervalMillis).hashCode());
        Long $nextFreeTicketMillis = this.getNextFreeTicketMillis();
        result = result * 59 + ($nextFreeTicketMillis == null ? 43 : ((Object)$nextFreeTicketMillis).hashCode());
        return result;
    }

    public String toString() {
        return "RedisPermits(maxPermits=" + this.getMaxPermits() + ", storedPermits=" + this.getStoredPermits() + ", intervalMillis=" + this.getIntervalMillis() + ", nextFreeTicketMillis=" + this.getNextFreeTicketMillis() + ")";
    }
}

