package com.bxm.newidea.component.redisson.utils;

import com.bxm.newidea.component.redis.DistributedLock;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import lombok.extern.slf4j.Slf4j;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/**
 * 令牌桶限流器工厂
 *
 * @author: Meng.Liu
 * @date: 2018/11/12 下午4:26
 */
@Slf4j
public class RateLimiterFactory {

    private final DistributedLock distributedLock;

    private final RedisStringAdapter redisStringAdapter;

    /**
     * 本地持有对象
     */
    private Map<String, RateLimiter> rateLimiterMap = new ConcurrentHashMap<>();

    public RateLimiterFactory(DistributedLock distributedLock, RedisStringAdapter redisStringAdapter) {
        this.distributedLock = distributedLock;
        this.redisStringAdapter = redisStringAdapter;
    }

    /**
     * 构建一个令牌桶
     *
     * @param key              令牌桶的唯一标识
     * @param permitsPerSecond 每秒产生的令牌数
     * @param maxBurstSeconds  最大存储多少秒的令牌
     * @return redis分布式令牌桶
     */
    public RateLimiter build(KeyGenerator key, Double permitsPerSecond, Integer maxBurstSeconds) {
        String keyStr = key.gen();
        rateLimiterMap.putIfAbsent(keyStr, new RateLimiter(key, permitsPerSecond, maxBurstSeconds, distributedLock, redisStringAdapter));
        return rateLimiterMap.get(keyStr);
    }
}