/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.component.redisson.config;

import com.bxm.newidea.component.redisson.config.RedissonClientBeanDefinitionFactory;
import com.bxm.newidea.component.redisson.config.RedissonClientHolder;
import com.bxm.newidea.component.redisson.config.RedissonConfigurationProperties;
import com.bxm.newidea.component.redisson.config.RedissonMetaInfo;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.util.Assert;

public class RedisClientRegister
implements ImportBeanDefinitionRegistrar,
EnvironmentAware {
    private static final Logger log = LoggerFactory.getLogger(RedisClientRegister.class);
    private Environment environment;
    private Binder binder;

    public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
        RedissonConfigurationProperties configurationMetaInfos = (RedissonConfigurationProperties)this.binder.bind("component.redisson", RedissonConfigurationProperties.class).get();
        Assert.notNull((Object)configurationMetaInfos, (String)"\u672a\u914d\u7f6eRedisson\u9ed8\u8ba4\u6570\u636e\u6e90\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e\uff01");
        Map<String, RedissonMetaInfo> configs = configurationMetaInfos.getMultiData();
        configs.put("default", this.buildDefaultRedissonMetaInfo(configurationMetaInfos));
        RedissonClientHolder redissonClientHolder = new RedissonClientHolder();
        RedissonClientBeanDefinitionFactory redissonClientBeanDefinitionFactory = new RedissonClientBeanDefinitionFactory(redissonClientHolder);
        String[] activeProfiles = this.environment.getActiveProfiles();
        configs.forEach((dataSourceName, metaInfo) -> {
            BeanDefinition beanDefinition = redissonClientBeanDefinitionFactory.get((String)dataSourceName, (RedissonMetaInfo)metaInfo, activeProfiles);
            registry.registerBeanDefinition(dataSourceName + "RedissonDataSource", beanDefinition);
        });
    }

    private RedissonMetaInfo buildDefaultRedissonMetaInfo(RedissonConfigurationProperties configurationMetaInfos) {
        RedissonMetaInfo redissonMetaInfo = new RedissonMetaInfo();
        BeanUtils.copyProperties((Object)configurationMetaInfos, (Object)redissonMetaInfo);
        return redissonMetaInfo;
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
        log.info("\u5f00\u59cb\u6ce8\u518c\u6570\u636e\u6e90");
        this.binder = Binder.get((Environment)environment);
    }
}

