/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.component.redisson.impl;

import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisListAdapter;
import com.bxm.newidea.component.redisson.config.SwitchMultiDataSourceHandler;
import com.bxm.newidea.component.redisson.impl.BaseRedisAdapter;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.lang3.ArrayUtils;
import org.redisson.api.RBlockingDeque;
import org.redisson.api.RDeque;
import org.redisson.api.RList;
import org.redisson.api.RQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class RedissonListAdapterImpl
extends BaseRedisAdapter
implements RedisListAdapter {
    private static final Logger log = LoggerFactory.getLogger(RedissonListAdapterImpl.class);

    public RedissonListAdapterImpl(SwitchMultiDataSourceHandler switchMultiDataSourceHandler) {
        super(switchMultiDataSourceHandler);
    }

    private RList rListOperations(KeyGenerator generator) {
        return this.switchMultiDataSourceHandler.getRedissonClient(generator.getDbName()).getList(generator.gen());
    }

    private RDeque rDequeOperations(KeyGenerator generator) {
        return this.switchMultiDataSourceHandler.getRedissonClient(generator.getDbName()).getDeque(generator.gen());
    }

    private RBlockingDeque bListOperations(KeyGenerator generator) {
        return this.switchMultiDataSourceHandler.getRedissonClient(generator.getDbName()).getBlockingDeque(generator.gen());
    }

    private RDeque lListOperations(KeyGenerator generator) {
        return this.switchMultiDataSourceHandler.getRedissonClient(generator.getDbName()).getDeque(generator.gen());
    }

    private RQueue lPopListOperations(KeyGenerator generator) {
        return this.switchMultiDataSourceHandler.getRedissonClient(generator.getDbName()).getQueue(generator.gen());
    }

    public Long leftPush(KeyGenerator generator, Object ... values) {
        return this.execPush(generator, true, values);
    }

    public <T> Long leftPush(KeyGenerator generator, List<T> value) {
        if (!CollectionUtils.isEmpty(value)) {
            return this.execPush(generator, true, value.toArray());
        }
        return 0L;
    }

    private <T> Long execPush(KeyGenerator generator, boolean isLeft, T[] values) {
        if (ArrayUtils.isEmpty((Object[])values)) {
            return 0L;
        }
        AtomicLong atomicLong = new AtomicLong();
        for (T obj : values) {
            if (isLeft) {
                boolean offerFirst = this.rDequeOperations(generator).offerFirst((Object)this.serializerString(obj));
                atomicLong.addAndGet(offerFirst ? 1L : 0L);
                continue;
            }
            boolean offerLast = this.rDequeOperations(generator).offerLast((Object)this.serializerString(obj));
            atomicLong.addAndGet(offerLast ? 1L : 0L);
        }
        return atomicLong.get();
    }

    private <T> List<String> convertToByteArray(T ... values) {
        ArrayList<String> dataArray = new ArrayList<String>();
        for (T obj : values) {
            dataArray.add(this.serializerString(obj));
        }
        return dataArray;
    }

    public <T> Long rightPush(KeyGenerator generator, T ... values) {
        return this.execPush(generator, false, values);
    }

    public <T> Long rightPush(KeyGenerator generator, List<T> values) {
        return this.execPush(generator, false, values.toArray());
    }

    public Long size(KeyGenerator generator) {
        return this.lListOperations(generator).size();
    }

    public <T> T leftPop(KeyGenerator generator, Class<T> clasz) {
        return this.execPop(generator, true, clasz, null);
    }

    public <T> T blockLeftPop(KeyGenerator generator, Class<T> clasz, long timeout, TimeUnit unit) {
        return this.blockExecPop(generator, true, clasz, null, timeout, unit);
    }

    private <T> T blockExecPop(KeyGenerator generator, boolean isLeft, Class<T> clasz, TypeReference<T> typeReference, long timeout, TimeUnit unit) {
        String value = null;
        try {
            value = isLeft ? (String)this.bListOperations(generator).pollFirst(timeout, unit) : (String)this.bListOperations(generator).pollLast(timeout, unit);
        }
        catch (InterruptedException e) {
            log.error("bListOperations\u963b\u585epop\u5217\u8868\u6570\u636e\u51fa\u9519\uff0cKeyGenerator\uff1a{}\uff0cisLeft\uff1a{}\uff0cclasz\uff1a{}\uff0ctypeReference\uff1a{}", new Object[]{generator, isLeft, clasz, typeReference, e});
            Thread.currentThread().interrupt();
        }
        return this.deSerializerString(value, clasz, typeReference);
    }

    public <T> T leftPop(KeyGenerator generator, TypeReference<T> typeReference) {
        return this.execPop(generator, true, null, typeReference);
    }

    private <T> T execPop(KeyGenerator generator, boolean isLeft, Class<T> clasz, TypeReference<T> typeReference) {
        String value = isLeft ? (String)this.lPopListOperations(generator).poll() : (String)this.lListOperations(generator).pollLast();
        return this.deSerializerString(value, clasz, typeReference);
    }

    public <T> T rightPop(KeyGenerator generator, Class<T> clasz) {
        return this.execPop(generator, false, clasz, null);
    }

    public <T> T blockRightPop(KeyGenerator generator, Class<T> clasz, long timeout, TimeUnit unit) {
        return this.blockExecPop(generator, false, clasz, null, timeout, unit);
    }

    public <T> T rightPop(KeyGenerator generator, TypeReference<T> typeReference) {
        return this.execPop(generator, false, null, typeReference);
    }

    public <T> List<T> leftIndex(KeyGenerator generator, long index, Class<T> clasz) {
        return this.range(generator, 0L, index, clasz);
    }

    public <T> List<T> leftIndex(KeyGenerator generator, long index, TypeReference<T> typeReference) {
        return this.range(generator, 0L, index, typeReference);
    }

    public <T> T index(KeyGenerator generator, long index, Class<T> clasz) {
        String value = (String)this.rListOperations(generator).get((int)index);
        if (value == null) {
            return null;
        }
        return this.deSerializerString(value, clasz, null);
    }

    public <T> T index(KeyGenerator generator, long index, TypeReference<T> typeReference) {
        String value = (String)this.rListOperations(generator).get((int)index);
        if (value == null) {
            return null;
        }
        return this.deSerializerString(value, null, typeReference);
    }

    public <T> List<T> range(KeyGenerator generator, long start, long end, Class<T> clasz) {
        ArrayList result = new ArrayList();
        List range = this.rListOperations(generator).range((int)start, (int)end);
        if (!CollectionUtils.isEmpty((Collection)range)) {
            range.forEach(value -> result.add(this.deSerializerString((String)value, clasz, null)));
        }
        return result;
    }

    public <T> List<T> range(KeyGenerator generator, long start, long end, TypeReference<T> typeReference) {
        ArrayList result = new ArrayList();
        List range = this.rListOperations(generator).range((int)start, (int)end);
        if (!CollectionUtils.isEmpty((Collection)range)) {
            range.forEach(value -> result.add(this.deSerializerString((String)value, null, typeReference)));
        }
        return result;
    }

    public void leftTrim(KeyGenerator generator, long start, long end) {
        this.rListOperations(generator).trim((int)start, (int)end);
    }
}

