/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.component.redisson.impl;

import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.redisson.config.RedissonConfigurationProperties;
import com.bxm.newidea.component.redisson.config.SwitchMultiDataSourceHandler;
import com.bxm.newidea.component.redisson.impl.BaseRedisAdapter;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.concurrent.TimeUnit;
import org.redisson.api.RAtomicDouble;
import org.redisson.api.RAtomicLong;
import org.redisson.api.RBucket;
import org.redisson.api.RTopic;

public class RedissonStringAdapterImpl
extends BaseRedisAdapter
implements RedisStringAdapter {
    private RedissonConfigurationProperties redissonConfigurationProperties;

    public RedissonStringAdapterImpl(SwitchMultiDataSourceHandler switchMultiDataSourceHandler, RedissonConfigurationProperties redissonConfigurationProperties) {
        super(switchMultiDataSourceHandler);
        this.redissonConfigurationProperties = redissonConfigurationProperties;
    }

    private RBucket<Object> stringOperations(KeyGenerator generator) {
        return this.switchMultiDataSourceHandler.getRedissonClient(generator.getDbName()).getBucket(generator.gen());
    }

    private RTopic topOperations(String key) {
        return this.switchMultiDataSourceHandler.getRedissonClient(this.redissonConfigurationProperties.getTopicDataSource()).getTopic(key);
    }

    private RAtomicDouble doubleOperations(KeyGenerator generator) {
        return this.switchMultiDataSourceHandler.getRedissonClient(generator.getDbName()).getAtomicDouble(generator.gen());
    }

    private RAtomicLong longOperations(KeyGenerator generator) {
        return this.switchMultiDataSourceHandler.getRedissonClient(generator.getDbName()).getAtomicLong(generator.gen());
    }

    public Long increment(KeyGenerator generator) {
        return this.increment(generator, 1);
    }

    public Long increment(KeyGenerator generator, int amount) {
        return this.incrementWithDefault(generator, 1L, amount, 0L);
    }

    public Long increment(KeyGenerator generator, long expireSeconds) {
        return this.incrementWithDefault(generator, 1L, 1, expireSeconds);
    }

    public Long incrementWithDefault(KeyGenerator generator, long defaultVal) {
        return this.incrementWithDefault(generator, defaultVal, 1, 0L);
    }

    public Long incrementWithDefault(KeyGenerator generator, long defaultVal, int amount) {
        return this.incrementWithDefault(generator, defaultVal, amount, 0L);
    }

    public Long incrementWithDefault(KeyGenerator generator, long defaultVal, int amount, long expireSeconds) {
        return this.exec(generator, defaultVal, amount, expireSeconds, true);
    }

    public Long decrement(KeyGenerator generator, long defaultVal, int amount, long expireSeconds) {
        return this.exec(generator, defaultVal, amount, expireSeconds, false);
    }

    public Long decrement(KeyGenerator generator) {
        return this.decrement(generator, 1L, 1, 0L);
    }

    public Long decrement(KeyGenerator generator, int amount) {
        return this.decrement(generator, 1L, amount, 0L);
    }

    public Long decrement(KeyGenerator generator, long expireSeconds) {
        return this.decrement(generator, 1L, 1, expireSeconds);
    }

    public Long decrement(KeyGenerator generator, long defaultVal, int amount) {
        return this.decrement(generator, defaultVal, amount, 0L);
    }

    public Long getLong(KeyGenerator generator) {
        return (long)this.doubleOperations(generator).get();
    }

    public Double getDouble(KeyGenerator generator) {
        return this.doubleOperations(generator).get();
    }

    public Integer getInt(KeyGenerator generator) {
        return (int)this.doubleOperations(generator).get();
    }

    public String getString(KeyGenerator generator) {
        Object value = this.stringOperations(generator).get();
        if (null == value) {
            return "";
        }
        return String.valueOf(value);
    }

    public <T> T get(KeyGenerator generator, Class<T> clasz) {
        Object value = this.stringOperations(generator).get();
        if (null == value) {
            return null;
        }
        return this.deSerializerString(String.valueOf(value), clasz, null);
    }

    public <T> T get(KeyGenerator generator, TypeReference<T> typeReference) {
        Object value = this.stringOperations(generator).get();
        if (null == value) {
            return null;
        }
        return this.deSerializerString(String.valueOf(value), null, typeReference);
    }

    public <T> void set(KeyGenerator generator, T value) {
        this.stringOperations(generator).set((Object)this.serializerString(value));
    }

    public void set(KeyGenerator generator, long value) {
        this.longOperations(generator).set(value);
    }

    public <T> void set(KeyGenerator generator, T value, long expireSeconds) {
        if (value instanceof String) {
            this.stringOperations(generator).set((Object)value.toString(), expireSeconds, TimeUnit.SECONDS);
        } else {
            this.stringOperations(generator).set((Object)this.serializerString(value), expireSeconds, TimeUnit.SECONDS);
        }
    }

    public void set(KeyGenerator generator, Double value) {
        this.doubleOperations(generator).set(value.doubleValue());
    }

    public Double increment(KeyGenerator generator, double amount) {
        return this.increment(generator, amount, amount, 0L);
    }

    public Double increment(KeyGenerator generator, double defaultVal, double amount, long expireSeconds) {
        return this.exec(generator, defaultVal, amount, expireSeconds, true);
    }

    public Double decrement(KeyGenerator generator, double amount) {
        return this.decrement(generator, 0.0, amount, 0L);
    }

    public Double decrement(KeyGenerator generator, double defaultVal, double amount, long expireSeconds) {
        return this.exec(generator, defaultVal, amount, expireSeconds, false);
    }

    public void convertAndSend(String channel, Object message) {
        this.topOperations(channel).publish(message);
    }

    private Long exec(KeyGenerator generator, long defaultVal, long amount, long expireSeconds, boolean isIncrement) {
        if (!this.hasKey(generator).booleanValue()) {
            this.longOperations(generator).set(defaultVal);
            if (expireSeconds > 0L) {
                this.longOperations(generator).expire(expireSeconds, TimeUnit.SECONDS);
            }
            return defaultVal;
        }
        amount = isIncrement ? amount : -amount;
        return this.longOperations(generator).addAndGet(amount);
    }

    private Double exec(KeyGenerator generator, double defaultVal, double amount, long expireSeconds, boolean isIncrement) {
        if (!this.hasKey(generator).booleanValue()) {
            this.doubleOperations(generator).set(defaultVal);
            if (expireSeconds > 0L) {
                this.doubleOperations(generator).expire(expireSeconds, TimeUnit.SECONDS);
            }
            return defaultVal;
        }
        amount = isIncrement ? amount : -amount;
        return this.doubleOperations(generator).addAndGet(amount);
    }
}

