/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.component.redisson.utils;

import com.bxm.newidea.component.redis.DistributedLock;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.redisson.utils.RateLimiter;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RateLimiterFactory {
    private static final Logger log = LoggerFactory.getLogger(RateLimiterFactory.class);
    private final DistributedLock distributedLock;
    private final RedisStringAdapter redisStringAdapter;
    private Map<String, RateLimiter> rateLimiterMap = new ConcurrentHashMap<String, RateLimiter>();

    public RateLimiterFactory(DistributedLock distributedLock, RedisStringAdapter redisStringAdapter) {
        this.distributedLock = distributedLock;
        this.redisStringAdapter = redisStringAdapter;
    }

    public RateLimiter build(KeyGenerator key, Double permitsPerSecond, Integer maxBurstSeconds) {
        String keyStr = key.gen();
        this.rateLimiterMap.putIfAbsent(keyStr, new RateLimiter(key, permitsPerSecond, maxBurstSeconds, this.distributedLock, this.redisStringAdapter));
        return this.rateLimiterMap.get(keyStr);
    }
}

