/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.component.redisson.config;

import cn.hutool.core.util.ClassLoaderUtil;
import com.bxm.newidea.component.redisson.config.RedissonConfigurationProperties;
import com.bxm.newidea.component.tools.StringUtils;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.kqueue.KQueueEventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import java.util.Set;
import org.redisson.Redisson;
import org.redisson.api.RedissonClient;
import org.redisson.client.codec.Codec;
import org.redisson.client.codec.StringCodec;
import org.redisson.config.BaseConfig;
import org.redisson.config.BaseMasterSlaveServersConfig;
import org.redisson.config.ClusterServersConfig;
import org.redisson.config.Config;
import org.redisson.config.MasterSlaveServersConfig;
import org.redisson.config.ReplicatedServersConfig;
import org.redisson.config.SentinelServersConfig;
import org.redisson.config.SingleServerConfig;
import org.redisson.config.TransportMode;
import org.redisson.connection.balancer.LoadBalancer;
import org.redisson.connection.balancer.RoundRobinLoadBalancer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import sun.awt.OSInfo;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={RedissonConfigurationProperties.class})
@ConditionalOnProperty(value={"component.redisson.type", "component.redisson.address"})
public class ComponentRedissonConfiguration {
    private static final Logger log = LoggerFactory.getLogger(ComponentRedissonConfiguration.class);
    private RedissonConfigurationProperties properties;

    public ComponentRedissonConfiguration(RedissonConfigurationProperties properties) {
        this.properties = properties;
    }

    @Bean
    @ConditionalOnMissingBean(value={RedissonClient.class})
    public RedissonClient redissonClient() {
        RedissonClient client;
        long start = System.currentTimeMillis();
        Config config = this.buildConfig();
        switch (this.properties.getType()) {
            case SINGLE: {
                client = this.buildSingleServer(config);
                break;
            }
            case CLUSTER: {
                client = this.clusterServersConfig(config);
                break;
            }
            case REPLICATED: {
                client = this.replicatedConfig(config);
                break;
            }
            case SENTINAL: {
                client = this.sentinalConfig(config);
                break;
            }
            case MASTER_SLAVE: {
                client = this.masterSlaveConfig(config);
                break;
            }
            default: {
                throw new IllegalArgumentException("\u672a\u63d0\u4f9bcomponent.redisson.type\u914d\u7f6e\uff0c\u6216\u8005\u914d\u7f6e\u503c\u4e0d\u5728\u679a\u4e3e\u8303\u56f4\u5185");
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("redisson \u542f\u52a8\u8017\u65f6\uff1a{}", (Object)(System.currentTimeMillis() - start));
        }
        return client;
    }

    private Config buildConfig() {
        Config config = new Config();
        OSInfo.OSType osType = OSInfo.getOSType();
        config.setEventLoopGroup((EventLoopGroup)new NioEventLoopGroup());
        config.setTransportMode(TransportMode.NIO);
        if (this.properties.getTransportMode() != null) {
            if (TransportMode.EPOLL.equals((Object)this.properties.getTransportMode())) {
                if (OSInfo.OSType.LINUX.equals((Object)osType)) {
                    config.setEventLoopGroup((EventLoopGroup)new EpollEventLoopGroup());
                    config.setTransportMode(TransportMode.EPOLL);
                }
            } else if (TransportMode.KQUEUE.equals((Object)this.properties.getTransportMode()) && OSInfo.OSType.MACOSX.equals((Object)osType)) {
                config.setEventLoopGroup((EventLoopGroup)new KQueueEventLoopGroup());
                config.setTransportMode(TransportMode.KQUEUE);
            }
        }
        config.setCodec((Codec)new StringCodec());
        return config;
    }

    private void setBaseConfig(BaseConfig serverConfig) {
        if (null != this.properties.getPassword()) {
            serverConfig.setPassword(this.properties.getPassword());
        }
        serverConfig.setClientName(this.properties.getClientName());
        serverConfig.setSubscriptionsPerConnection(this.properties.getSubscriptionsPerConnection());
        serverConfig.setConnectTimeout(this.properties.getConnectTimeout());
        serverConfig.setIdleConnectionTimeout(this.properties.getIdleConnectionTimeout());
        serverConfig.setTimeout(this.properties.getTimeout());
        serverConfig.setRetryAttempts(this.properties.getRetryAttempts());
        serverConfig.setRetryInterval(this.properties.getRetryInterval());
    }

    private void setMasterSlaveConfig(BaseMasterSlaveServersConfig slaveConfig) {
        slaveConfig.setMasterConnectionMinimumIdleSize(this.properties.getMasterConnectionMinimumIdleSize());
        slaveConfig.setMasterConnectionPoolSize(this.properties.getMasterConnectionPoolSize());
        slaveConfig.setSlaveConnectionMinimumIdleSize(this.properties.getSlaveConnectionMinimumIdleSize());
        slaveConfig.setSlaveConnectionPoolSize(this.properties.getSlaveConnectionPoolSize());
        slaveConfig.setSubscriptionConnectionMinimumIdleSize(this.properties.getSubscriptionConnectionMinimumIdleSize());
        slaveConfig.setSubscriptionConnectionPoolSize(this.properties.getSubscriptionConnectionPoolSize());
        slaveConfig.setSubscriptionMode(this.properties.getSubscriptionMode());
        slaveConfig.setReadMode(this.properties.getReadMode());
        try {
            if (null != this.properties.getLoadBalancer()) {
                LoadBalancer loadBalancer = (LoadBalancer)ClassLoaderUtil.loadClass((String)this.properties.getLoadBalancer()).newInstance();
                slaveConfig.setLoadBalancer(loadBalancer);
            }
        }
        catch (IllegalAccessException | InstantiationException e) {
            log.error("\u914d\u7f6e\u7684[{}]\u65e0\u6cd5\u5b9e\u4f8b\u5316\uff0c\u9ed8\u8ba4\u4f7f\u7528\u8f6e\u8be2", (Object)this.properties.getLoadBalancer());
            slaveConfig.setLoadBalancer((LoadBalancer)new RoundRobinLoadBalancer());
        }
    }

    private RedissonClient sentinalConfig(Config config) {
        Preconditions.checkNotNull((Object)this.properties.getAddress(), (Object)"\u54e8\u5175\u6a21\u5f0f\u5fc5\u987b\u63d0\u4f9b\u8fde\u63a5\u5730\u5740\uff1acomponent.redisson.address");
        Preconditions.checkNotNull((Object)this.properties.getMasterName(), (Object)"\u54e8\u5175\u6a21\u5f0f\u5fc5\u987b\u63d0\u4f9b\u4e3b\u8282\u70b9\u540d\u79f0\uff1acomponent.redisson.masterName");
        SentinelServersConfig serverConfig = config.useSentinelServers();
        this.setBaseConfig((BaseConfig)serverConfig);
        this.setMasterSlaveConfig((BaseMasterSlaveServersConfig)serverConfig);
        serverConfig.setMasterName(this.properties.getMasterName());
        serverConfig.addSentinelAddress(StringUtils.split((String)this.properties.getAddress(), (String)","));
        if (null != this.properties.getSentinelPassword()) {
            serverConfig.setSentinelPassword(this.properties.getSentinelPassword());
        }
        serverConfig.setDatabase(this.properties.getDatabase());
        return Redisson.create((Config)config);
    }

    private RedissonClient replicatedConfig(Config config) {
        Preconditions.checkNotNull((Object)this.properties.getAddress(), (Object)"\u4e91\u6258\u7ba1\u6a21\u5f0f\u5fc5\u987b\u63d0\u4f9b\u8fde\u63a5\u5730\u5740\uff1acomponent.redisson.address");
        ReplicatedServersConfig serverConfig = config.useReplicatedServers();
        serverConfig.addNodeAddress(StringUtils.split((String)this.properties.getAddress(), (String)","));
        this.setBaseConfig((BaseConfig)serverConfig);
        this.setMasterSlaveConfig((BaseMasterSlaveServersConfig)serverConfig);
        serverConfig.setDatabase(this.properties.getDatabase());
        serverConfig.setScanInterval(this.properties.getClusterScanInterval());
        return Redisson.create((Config)config);
    }

    private RedissonClient masterSlaveConfig(Config config) {
        Preconditions.checkNotNull((Object)this.properties.getAddress(), (Object)"\u4e3b\u4ece\u6a21\u5f0f\u5fc5\u987b\u63d0\u4f9b\u4e3b\u8282\u70b9\u8fde\u63a5\u5730\u5740\uff1acomponent.redisson.address");
        Preconditions.checkNotNull((Object)this.properties.getSlaveAddress(), (Object)"\u4e3b\u4ece\u6a21\u5f0f\u5fc5\u987b\u63d0\u4f9b\u4ece\u8282\u70b9\u8fde\u63a5\u5730\u5740:component.redisson.slaveAddress");
        MasterSlaveServersConfig serverConfig = config.useMasterSlaveServers();
        serverConfig.setMasterAddress(this.properties.getAddress());
        serverConfig.setSlaveAddresses((Set)Sets.newHashSet((Object[])StringUtils.split((String)this.properties.getSlaveAddress(), (String)",")));
        this.setBaseConfig((BaseConfig)serverConfig);
        this.setMasterSlaveConfig((BaseMasterSlaveServersConfig)serverConfig);
        serverConfig.setDatabase(this.properties.getDatabase());
        return Redisson.create((Config)config);
    }

    private RedissonClient buildSingleServer(Config config) {
        Preconditions.checkNotNull((Object)this.properties.getAddress(), (Object)"\u5355\u5b9e\u4f8b\u6a21\u5f0f\u5fc5\u987b\u63d0\u4f9b\u8fde\u63a5\u5730\u5740\uff1acomponent.redisson.address");
        SingleServerConfig serverConfig = config.useSingleServer();
        serverConfig.setAddress(this.properties.getAddress());
        this.setBaseConfig((BaseConfig)serverConfig);
        serverConfig.setDatabase(this.properties.getDatabase());
        serverConfig.setSubscriptionConnectionMinimumIdleSize(this.properties.getSubscriptionConnectionMinimumIdleSize());
        serverConfig.setSubscriptionConnectionPoolSize(this.properties.getSubscriptionConnectionPoolSize());
        serverConfig.setConnectionMinimumIdleSize(this.properties.getConnectionMinimumIdleSize());
        return Redisson.create((Config)config);
    }

    private RedissonClient clusterServersConfig(Config config) {
        Preconditions.checkNotNull((Object)this.properties.getAddress(), (Object)"\u96c6\u7fa4\u6a21\u5f0f\u5fc5\u987b\u63d0\u4f9b\u8fde\u63a5\u5730\u5740\uff1acomponent.redisson.address");
        ClusterServersConfig serverConfig = config.useClusterServers();
        serverConfig.addNodeAddress(StringUtils.split((String)this.properties.getAddress(), (String)","));
        this.setBaseConfig((BaseConfig)serverConfig);
        this.setMasterSlaveConfig((BaseMasterSlaveServersConfig)serverConfig);
        return Redisson.create((Config)config);
    }
}

