/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.component.redisson.config;

import com.bxm.newidea.component.redisson.enums.RedissonClientTypeEnum;
import org.redisson.config.ReadMode;
import org.redisson.config.SubscriptionMode;
import org.redisson.config.TransportMode;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="component.redisson")
public class RedissonConfigurationProperties {
    private RedissonClientTypeEnum type = RedissonClientTypeEnum.SINGLE;
    private String address;
    private String password;
    private TransportMode transportMode = TransportMode.NIO;
    private int idleConnectionTimeout = 10000;
    private int connectTimeout = 5000;
    private int timeout = 200;
    private int retryAttempts = 3;
    private int retryInterval = 100;
    private int subscriptionsPerConnection = 5;
    private int subscriptionConnectionMinimumIdleSize = 5;
    private int subscriptionConnectionPoolSize = 50;
    @Value(value="${spring.application.name:redisson_client}")
    private String clientName;
    private int clusterScanInterval = 2000;
    private int slaveConnectionMinimumIdleSize = 32;
    private int slaveConnectionPoolSize = 64;
    private int masterConnectionMinimumIdleSize = 32;
    private int masterConnectionPoolSize = 62;
    private String loadBalancer = "org.redisson.connection.balancer.RoundRobinLoadBalancer";
    private ReadMode readMode = ReadMode.SLAVE;
    private SubscriptionMode subscriptionMode = SubscriptionMode.SLAVE;
    private String masterName;
    private String sentinelPassword;
    private String slaveAddress;
    private int database = 0;
    private int connectionMinimumIdleSize = 24;

    public RedissonClientTypeEnum getType() {
        return this.type;
    }

    public String getAddress() {
        return this.address;
    }

    public String getPassword() {
        return this.password;
    }

    public TransportMode getTransportMode() {
        return this.transportMode;
    }

    public int getIdleConnectionTimeout() {
        return this.idleConnectionTimeout;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public int getRetryAttempts() {
        return this.retryAttempts;
    }

    public int getRetryInterval() {
        return this.retryInterval;
    }

    public int getSubscriptionsPerConnection() {
        return this.subscriptionsPerConnection;
    }

    public int getSubscriptionConnectionMinimumIdleSize() {
        return this.subscriptionConnectionMinimumIdleSize;
    }

    public int getSubscriptionConnectionPoolSize() {
        return this.subscriptionConnectionPoolSize;
    }

    public String getClientName() {
        return this.clientName;
    }

    public int getClusterScanInterval() {
        return this.clusterScanInterval;
    }

    public int getSlaveConnectionMinimumIdleSize() {
        return this.slaveConnectionMinimumIdleSize;
    }

    public int getSlaveConnectionPoolSize() {
        return this.slaveConnectionPoolSize;
    }

    public int getMasterConnectionMinimumIdleSize() {
        return this.masterConnectionMinimumIdleSize;
    }

    public int getMasterConnectionPoolSize() {
        return this.masterConnectionPoolSize;
    }

    public String getLoadBalancer() {
        return this.loadBalancer;
    }

    public ReadMode getReadMode() {
        return this.readMode;
    }

    public SubscriptionMode getSubscriptionMode() {
        return this.subscriptionMode;
    }

    public String getMasterName() {
        return this.masterName;
    }

    public String getSentinelPassword() {
        return this.sentinelPassword;
    }

    public String getSlaveAddress() {
        return this.slaveAddress;
    }

    public int getDatabase() {
        return this.database;
    }

    public int getConnectionMinimumIdleSize() {
        return this.connectionMinimumIdleSize;
    }

    public void setType(RedissonClientTypeEnum type) {
        this.type = type;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setTransportMode(TransportMode transportMode) {
        this.transportMode = transportMode;
    }

    public void setIdleConnectionTimeout(int idleConnectionTimeout) {
        this.idleConnectionTimeout = idleConnectionTimeout;
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public void setRetryAttempts(int retryAttempts) {
        this.retryAttempts = retryAttempts;
    }

    public void setRetryInterval(int retryInterval) {
        this.retryInterval = retryInterval;
    }

    public void setSubscriptionsPerConnection(int subscriptionsPerConnection) {
        this.subscriptionsPerConnection = subscriptionsPerConnection;
    }

    public void setSubscriptionConnectionMinimumIdleSize(int subscriptionConnectionMinimumIdleSize) {
        this.subscriptionConnectionMinimumIdleSize = subscriptionConnectionMinimumIdleSize;
    }

    public void setSubscriptionConnectionPoolSize(int subscriptionConnectionPoolSize) {
        this.subscriptionConnectionPoolSize = subscriptionConnectionPoolSize;
    }

    public void setClientName(String clientName) {
        this.clientName = clientName;
    }

    public void setClusterScanInterval(int clusterScanInterval) {
        this.clusterScanInterval = clusterScanInterval;
    }

    public void setSlaveConnectionMinimumIdleSize(int slaveConnectionMinimumIdleSize) {
        this.slaveConnectionMinimumIdleSize = slaveConnectionMinimumIdleSize;
    }

    public void setSlaveConnectionPoolSize(int slaveConnectionPoolSize) {
        this.slaveConnectionPoolSize = slaveConnectionPoolSize;
    }

    public void setMasterConnectionMinimumIdleSize(int masterConnectionMinimumIdleSize) {
        this.masterConnectionMinimumIdleSize = masterConnectionMinimumIdleSize;
    }

    public void setMasterConnectionPoolSize(int masterConnectionPoolSize) {
        this.masterConnectionPoolSize = masterConnectionPoolSize;
    }

    public void setLoadBalancer(String loadBalancer) {
        this.loadBalancer = loadBalancer;
    }

    public void setReadMode(ReadMode readMode) {
        this.readMode = readMode;
    }

    public void setSubscriptionMode(SubscriptionMode subscriptionMode) {
        this.subscriptionMode = subscriptionMode;
    }

    public void setMasterName(String masterName) {
        this.masterName = masterName;
    }

    public void setSentinelPassword(String sentinelPassword) {
        this.sentinelPassword = sentinelPassword;
    }

    public void setSlaveAddress(String slaveAddress) {
        this.slaveAddress = slaveAddress;
    }

    public void setDatabase(int database) {
        this.database = database;
    }

    public void setConnectionMinimumIdleSize(int connectionMinimumIdleSize) {
        this.connectionMinimumIdleSize = connectionMinimumIdleSize;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RedissonConfigurationProperties)) {
            return false;
        }
        RedissonConfigurationProperties other = (RedissonConfigurationProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getIdleConnectionTimeout() != other.getIdleConnectionTimeout()) {
            return false;
        }
        if (this.getConnectTimeout() != other.getConnectTimeout()) {
            return false;
        }
        if (this.getTimeout() != other.getTimeout()) {
            return false;
        }
        if (this.getRetryAttempts() != other.getRetryAttempts()) {
            return false;
        }
        if (this.getRetryInterval() != other.getRetryInterval()) {
            return false;
        }
        if (this.getSubscriptionsPerConnection() != other.getSubscriptionsPerConnection()) {
            return false;
        }
        if (this.getSubscriptionConnectionMinimumIdleSize() != other.getSubscriptionConnectionMinimumIdleSize()) {
            return false;
        }
        if (this.getSubscriptionConnectionPoolSize() != other.getSubscriptionConnectionPoolSize()) {
            return false;
        }
        if (this.getClusterScanInterval() != other.getClusterScanInterval()) {
            return false;
        }
        if (this.getSlaveConnectionMinimumIdleSize() != other.getSlaveConnectionMinimumIdleSize()) {
            return false;
        }
        if (this.getSlaveConnectionPoolSize() != other.getSlaveConnectionPoolSize()) {
            return false;
        }
        if (this.getMasterConnectionMinimumIdleSize() != other.getMasterConnectionMinimumIdleSize()) {
            return false;
        }
        if (this.getMasterConnectionPoolSize() != other.getMasterConnectionPoolSize()) {
            return false;
        }
        if (this.getDatabase() != other.getDatabase()) {
            return false;
        }
        if (this.getConnectionMinimumIdleSize() != other.getConnectionMinimumIdleSize()) {
            return false;
        }
        RedissonClientTypeEnum this$type = this.getType();
        RedissonClientTypeEnum other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        String this$address = this.getAddress();
        String other$address = other.getAddress();
        if (this$address == null ? other$address != null : !this$address.equals(other$address)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        TransportMode this$transportMode = this.getTransportMode();
        TransportMode other$transportMode = other.getTransportMode();
        if (this$transportMode == null ? other$transportMode != null : !this$transportMode.equals(other$transportMode)) {
            return false;
        }
        String this$clientName = this.getClientName();
        String other$clientName = other.getClientName();
        if (this$clientName == null ? other$clientName != null : !this$clientName.equals(other$clientName)) {
            return false;
        }
        String this$loadBalancer = this.getLoadBalancer();
        String other$loadBalancer = other.getLoadBalancer();
        if (this$loadBalancer == null ? other$loadBalancer != null : !this$loadBalancer.equals(other$loadBalancer)) {
            return false;
        }
        ReadMode this$readMode = this.getReadMode();
        ReadMode other$readMode = other.getReadMode();
        if (this$readMode == null ? other$readMode != null : !this$readMode.equals(other$readMode)) {
            return false;
        }
        SubscriptionMode this$subscriptionMode = this.getSubscriptionMode();
        SubscriptionMode other$subscriptionMode = other.getSubscriptionMode();
        if (this$subscriptionMode == null ? other$subscriptionMode != null : !this$subscriptionMode.equals(other$subscriptionMode)) {
            return false;
        }
        String this$masterName = this.getMasterName();
        String other$masterName = other.getMasterName();
        if (this$masterName == null ? other$masterName != null : !this$masterName.equals(other$masterName)) {
            return false;
        }
        String this$sentinelPassword = this.getSentinelPassword();
        String other$sentinelPassword = other.getSentinelPassword();
        if (this$sentinelPassword == null ? other$sentinelPassword != null : !this$sentinelPassword.equals(other$sentinelPassword)) {
            return false;
        }
        String this$slaveAddress = this.getSlaveAddress();
        String other$slaveAddress = other.getSlaveAddress();
        return !(this$slaveAddress == null ? other$slaveAddress != null : !this$slaveAddress.equals(other$slaveAddress));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RedissonConfigurationProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getIdleConnectionTimeout();
        result = result * 59 + this.getConnectTimeout();
        result = result * 59 + this.getTimeout();
        result = result * 59 + this.getRetryAttempts();
        result = result * 59 + this.getRetryInterval();
        result = result * 59 + this.getSubscriptionsPerConnection();
        result = result * 59 + this.getSubscriptionConnectionMinimumIdleSize();
        result = result * 59 + this.getSubscriptionConnectionPoolSize();
        result = result * 59 + this.getClusterScanInterval();
        result = result * 59 + this.getSlaveConnectionMinimumIdleSize();
        result = result * 59 + this.getSlaveConnectionPoolSize();
        result = result * 59 + this.getMasterConnectionMinimumIdleSize();
        result = result * 59 + this.getMasterConnectionPoolSize();
        result = result * 59 + this.getDatabase();
        result = result * 59 + this.getConnectionMinimumIdleSize();
        RedissonClientTypeEnum $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        String $address = this.getAddress();
        result = result * 59 + ($address == null ? 43 : $address.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        TransportMode $transportMode = this.getTransportMode();
        result = result * 59 + ($transportMode == null ? 43 : $transportMode.hashCode());
        String $clientName = this.getClientName();
        result = result * 59 + ($clientName == null ? 43 : $clientName.hashCode());
        String $loadBalancer = this.getLoadBalancer();
        result = result * 59 + ($loadBalancer == null ? 43 : $loadBalancer.hashCode());
        ReadMode $readMode = this.getReadMode();
        result = result * 59 + ($readMode == null ? 43 : $readMode.hashCode());
        SubscriptionMode $subscriptionMode = this.getSubscriptionMode();
        result = result * 59 + ($subscriptionMode == null ? 43 : $subscriptionMode.hashCode());
        String $masterName = this.getMasterName();
        result = result * 59 + ($masterName == null ? 43 : $masterName.hashCode());
        String $sentinelPassword = this.getSentinelPassword();
        result = result * 59 + ($sentinelPassword == null ? 43 : $sentinelPassword.hashCode());
        String $slaveAddress = this.getSlaveAddress();
        result = result * 59 + ($slaveAddress == null ? 43 : $slaveAddress.hashCode());
        return result;
    }

    public String toString() {
        return "RedissonConfigurationProperties(type=" + (Object)((Object)this.getType()) + ", address=" + this.getAddress() + ", password=" + this.getPassword() + ", transportMode=" + this.getTransportMode() + ", idleConnectionTimeout=" + this.getIdleConnectionTimeout() + ", connectTimeout=" + this.getConnectTimeout() + ", timeout=" + this.getTimeout() + ", retryAttempts=" + this.getRetryAttempts() + ", retryInterval=" + this.getRetryInterval() + ", subscriptionsPerConnection=" + this.getSubscriptionsPerConnection() + ", subscriptionConnectionMinimumIdleSize=" + this.getSubscriptionConnectionMinimumIdleSize() + ", subscriptionConnectionPoolSize=" + this.getSubscriptionConnectionPoolSize() + ", clientName=" + this.getClientName() + ", clusterScanInterval=" + this.getClusterScanInterval() + ", slaveConnectionMinimumIdleSize=" + this.getSlaveConnectionMinimumIdleSize() + ", slaveConnectionPoolSize=" + this.getSlaveConnectionPoolSize() + ", masterConnectionMinimumIdleSize=" + this.getMasterConnectionMinimumIdleSize() + ", masterConnectionPoolSize=" + this.getMasterConnectionPoolSize() + ", loadBalancer=" + this.getLoadBalancer() + ", readMode=" + this.getReadMode() + ", subscriptionMode=" + this.getSubscriptionMode() + ", masterName=" + this.getMasterName() + ", sentinelPassword=" + this.getSentinelPassword() + ", slaveAddress=" + this.getSlaveAddress() + ", database=" + this.getDatabase() + ", connectionMinimumIdleSize=" + this.getConnectionMinimumIdleSize() + ")";
    }
}

