/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.component.redisson.utils;

import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.redisson.impl.RedissonDistributedLockImpl;
import com.bxm.newidea.component.redisson.utils.RateLimiter;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RateLimiterFactory {
    private static final Logger log = LoggerFactory.getLogger(RateLimiterFactory.class);
    private final RedissonDistributedLockImpl redissonDistributedLockImpl;
    private final RedisStringAdapter redisStringAdapter;
    private Map<String, RateLimiter> rateLimiterMap = new ConcurrentHashMap<String, RateLimiter>();

    @Autowired
    public RateLimiterFactory(RedissonDistributedLockImpl redissonDistributedLockImpl, RedisStringAdapter redisStringAdapter) {
        this.redissonDistributedLockImpl = redissonDistributedLockImpl;
        this.redisStringAdapter = redisStringAdapter;
    }

    public RateLimiter build(KeyGenerator key, Double permitsPerSecond, Integer maxBurstSeconds) {
        String keyStr = key.gen();
        this.rateLimiterMap.putIfAbsent(keyStr, new RateLimiter(key, permitsPerSecond, maxBurstSeconds, this.redissonDistributedLockImpl, this.redisStringAdapter));
        return this.rateLimiterMap.get(keyStr);
    }
}

