/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.component.redis.impl;

import com.bxm.newidea.component.redis.HyperLogLogAdapter;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.impl.BaseRedisAdapter;
import java.util.Arrays;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.HyperLogLogOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;

@Component
public class HyperLogLogAdapterImpl
extends BaseRedisAdapter
implements HyperLogLogAdapter {
    private HyperLogLogOperations<String, Object> hyperLogLogOperations;

    @Autowired
    public HyperLogLogAdapterImpl(RedisTemplate<String, Object> redisTemplate) {
        super(redisTemplate);
        this.hyperLogLogOperations = redisTemplate.opsForHyperLogLog();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SafeVarargs
    public final <T> Long add(KeyGenerator keyGenerator, T ... value) {
        String key = keyGenerator.gen();
        try {
            this.redisTemplate.watch((Object)key);
            this.redisTemplate.multi();
            Long l = this.hyperLogLogOperations.add((Object)key, (Object[])this.serializeWithoutType(value));
            return l;
        }
        finally {
            this.redisTemplate.unwatch();
        }
    }

    public Long size(KeyGenerator ... keyGenerators) {
        Object[] keyGeneratorArray = (String[])Arrays.stream(keyGenerators).map(KeyGenerator::gen).toArray(String[]::new);
        return this.hyperLogLogOperations.size(keyGeneratorArray);
    }

    public Long union(KeyGenerator keyGenerator, KeyGenerator ... sourceKeyGenerators) {
        Object[] keyGeneratorArray = (String[])Arrays.stream(sourceKeyGenerators).map(KeyGenerator::gen).toArray(String[]::new);
        return this.hyperLogLogOperations.union((Object)keyGenerator.gen(), keyGeneratorArray);
    }
}

