package com.bxm.newidea.component.strategy;

import org.springframework.core.Ordered;

/**
 * 策略接口，通过参数匹配策略，如果匹配则执行对应的逻辑
 *
 * @author liujia
 * @date 1/13/21 6:44 PM
 **/
public interface IStrategy<T> extends Ordered {

    /**
     * 是否匹配当前策略
     *
     * @param context 策略处理上下文
     * @return true表示匹配当前策略
     */
    boolean match(T context);

    /**
     * 执行对应的策略逻辑
     *
     * @param context 策略处理上下文
     */
    void execute(T context);

    @Override
    default int getOrder() {
        // 默认不需要设置排序，如果出现多个相同的策略，可以通过顺序控制
        return 0;
    }
}
