package com.bxm.newidea.component.filter;

import java.util.List;

public class LogicFilterChain<Context> {

    private List<ILogicFilter> filters;

    private int index;

    public LogicFilterChain(List<ILogicFilter> filters) {
        this.filters = filters;
        this.index = 0;
    }

    public LogicFilterChain(List<ILogicFilter> filters, int index) {
        this.filters = filters;
        this.index = index;
    }

    public void filter(Context context) {
        if (index > filters.size() - 1) {
            return;
        }
        
        ILogicFilter filter = filters.get(index);
        LogicFilterChain<Context> filterChain = new LogicFilterChain<>(this.filters, index + 1);
        filter.filter(filterChain, context);
    }
}
