package com.bxm.newidea.component.rule;

import org.springframework.core.Ordered;

/**
 * spring统一的规则处理
 * 可用于多种规则的线型处理或并行处理
 * 不同于过滤器，规则执行失败会中断
 *
 * @author liujia
 * @date 1/13/21 5:55 PM
 **/
public interface IRule<T> extends Ordered {

    /**
     * 执行规则对应的逻辑
     *
     * @param context 判断上下文
     * @return 执行结果。如果为true则继续执行后续的规则，如果为false则直接中断
     */
    boolean apply(T context);
}
