package com.bxm.component.tbk.order.model.dto;

import com.alibaba.fastjson.annotation.JSONField;
import lombok.Data;

import java.math.BigDecimal;

@Data
public class MeituanOrderDetailInfo {

    /**
     * 15901
     * 商品类目，以实际商家平台结果为准
     */
    @JSONField(name = "goods_cate")
    private String goodsCate;

    /**
     * 15901-15902-15909
     * 商品类目名称，有可能是数字标识、文字说明，以实际商家平台结果为准
     */
    @JSONField(name = "goods_cate_name")
    private String goodsCateName;

    /**
     * 	3723618
     * 	商品编号
     */
    @JSONField(name = "goods_id")
    private String goodsId;

    /**
     * 	泉林本色卷纸 3层280节27卷 耐用高节数 易溶不堵塞马桶 不漂白本色卫生厕卷
     * 	商品名称
     */
    @JSONField(name = "goods_name")
    private String goodsName;

    /**
     * 	49.80
     * 	商品单价
     */
    @JSONField(name = "goods_price")
    private BigDecimal goodsPrice;

    /**
     * 	2
     * 	商品件数
     */
    @JSONField(name = "goods_ta")
    private Integer goodsTa;

    /**
     * 	79.68
     * 	订单金额
     */
    @JSONField(name = "orders_price")
    private BigDecimal ordersPrice;

    /**
     * 	已付款
     * 	商家平台原始订单状态描述，有可能是英文、中文、数值等，以实际结果为准。 与多麦联盟订单状态无对应关系
     */
    @JSONField(name = "order_status")
    private String orderStatus;

    /**
     * 	5
     * 	预估站长佣金，非结算站长佣金
     */
    @JSONField(name = "order_commission")
    private BigDecimal orderCommission;

}
