/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.component.tbk.order.model.enums;

import com.bxm.component.tbk.order.model.enums.TbkOrderStatusEnum;
import java.util.Objects;

public enum OrderStatusEnum {
    UNSETTLED(0, "\u5f85\u7ed3\u7b97"),
    HAVE_SETTLED(1, "\u5df2\u7ed3\u7b97"),
    INVALID(2, "\u5df2\u5931\u6548"),
    UNPAY(3, "\u5f85\u652f\u4ed8"),
    TIMEOUT_PAY(4, "\u8d85\u65f6\u672a\u652f\u4ed8"),
    CANCLE_PAY(5, "\u53d6\u6d88\u652f\u4ed8"),
    SUCCESS_PAY(6, "\u6210\u529f\u652f\u4ed8"),
    VERIFICATION_PAY(7, "\u6838\u9500\u6210\u529f"),
    REFUNDING(8, "\u9000\u5355\u4e2d"),
    REFUND_SUCCESS(9, "\u9000\u5355\u6210\u529f"),
    REFUND_REFUSE(10, "\u62d2\u7edd\u9000\u5355\u5f85\u6838\u9500");

    private Integer status;
    private String description;

    private OrderStatusEnum(Integer status, String description) {
        this.status = status;
        this.description = description;
    }

    public Integer getStatus() {
        return this.status;
    }

    public String getDescription() {
        return this.description;
    }

    public static Integer getOrderStatus(Integer tbOrderStatus) {
        if (TbkOrderStatusEnum.INVALID.getStatus().equals(tbOrderStatus)) {
            return INVALID.getStatus();
        }
        return UNSETTLED.getStatus();
    }

    public static boolean isInvalidOrder(Integer orderStatus) {
        return Objects.nonNull(orderStatus) && INVALID.getStatus().equals(orderStatus);
    }
}

