package com.bxm.component.tbk.order.model.constant;

import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.impl.DefaultKeyGenerator;

/**
 * 订单相关redis缓存key
 * @author Gonzo
 * @date  2020-05-02 14:06
 * @since 2.0.0
 */
public class OrderRedisKeyConstant {

    private static KeyGenerator BASE_KEY = DefaultKeyGenerator.build().setModule("order");

    /**
     * 定时同步订单数据 缓存状态值
     */
    public static KeyGenerator ORDER_SYNCRONIZE_UPDATE_KEY = BASE_KEY.copy().setGroup("synchronized").setKey("update");

    /**
     * 定时拉取渠道订单数据-存储最后一次拉取订单的时间
     */
    public static KeyGenerator PULL_ORDER_TIME = BASE_KEY.copy().setGroup("pull");


    /**
     * 定时拉取渠道订单数据-存储最后一次拉取订单的时间
     */
    public static KeyGenerator PULL_ORDER_TIME_BY_DAY = BASE_KEY.copy().setGroup("pull").setKey("day");

    /**
     * 定时拉取常规订单数据-存储最后一次拉取订单的时间
     */
    public static KeyGenerator PULL_ORDER_TIME_GENERAL = BASE_KEY.copy().setGroup("pull").setKey("general");

    /**
     * 定时拉取渠道订单锁
     */
    public static KeyGenerator PULL_ORDER_LOCK = BASE_KEY.copy().setGroup("pull").setKey("lock");

}
