package com.bxm.component.tbk.order.model.dto;

import com.alibaba.fastjson.annotation.JSONField;
import lombok.Data;

import java.math.BigDecimal;

@Data
public class MeituanOrderInfo {

    /**
     * 推送ID
     */
    private String id;

    /**
     * 推广计划ID
     */
    @JSONField(name = "ads_id")
    private String adsId;

    /**
     * 	推广计划名称
     */
    @JSONField(name = "ads_name")
    private String adsName;

    /**
     * 媒体ID
     */
    @JSONField(name = "site_id")
    private String siteId;


    /**
     * 推广计划链接ID
     */
    @JSONField(name = "link_id")
    private String linkId;

    /**
     * 订单的反馈标签值
     */
    private String euid;

    /**
     * 订单编号
     */
    @JSONField(name = "order_sn")
    private String orderSn;

    /**
     * 订单下单时间
     */
    @JSONField(name = "order_time")
    private String orderTime;

    /**
     * 订单金额，当订单状态为 1 或者为 2 时， order_price 表示确认订单金额
     */
    @JSONField(name = "orders_price")
    private BigDecimal ordersPrice;

    /**
     * 订单佣金，当订单状态为 1 或者为 2 时，siter_commission 表示确认佣金，其他状态值为 订单预估佣金
     */
    @JSONField(name = "siter_commission")
    private BigDecimal siterCommission;

    /**
     * 推送数据校验参数,checksum=MD5（按照参数首字母升序排列后 “参数值”拼接string + 接口密钥hash），拼接的参数值中不包括checksum和id参数值
     */
    private String checksum;

    /**
     * 订单状态 -1 无效 0 未确认 1 确认 2 结算
     */
    private Integer status;

    // -----------------以下字段在订单查询接口中才有，订单推送是不返回的---------------------------------------

    /**
     * 	0.00	确认订单金额
     */
    @JSONField(name = "confirm_price")
    private BigDecimal confirmPrice;

    /**
     * 	0.00	确认订单佣金
     */
    @JSONField(name = "confirm_siter_commission")
    private BigDecimal confirmSiterCommission;

    /**
     * 	0000-00-00 00:00:00	结算时间
     */
    @JSONField(name = "charge_time")
    private String chargeTime;

}
