package com.bxm.component.tbk.order.service;

import com.bxm.component.tbk.order.model.dto.TbkOrderInfo;

import java.time.LocalDateTime;

/**
 * 饿了么外卖订单处理
 * @author Gonzo
 * @date  2020-05-03 16:58
 * @since 2.0.0
 */
public interface EleTakeOutOrderService {
    /**
     * 同步订单信息
     *
     * @param orderInfo 饿了么订单信息
     * @return 处理是否成功
     */
    boolean syncOrder(TbkOrderInfo orderInfo);

    /**
     * 每日一次的订单状态同步
     */
    void syncOrderStatusDays();

    /**
     * 同步指定时间内的饿了么订单状态信息
     *
     * @param orderStartTime 开始时间
     * @param orderEndTime   结束时间
     */
    void syncOrderStatus(LocalDateTime orderStartTime, LocalDateTime orderEndTime);

}