package com.bxm.component.tbk.order.service;

import com.bxm.component.tbk.order.model.enums.OrderTypeEnum;

import java.time.LocalDateTime;

/**
 * 商品、饿了么订单拉取
 * @author Gonzo
 * @date  2020-05-03 16:59
 * @since 2.0.0
 */
public interface PullOrderService {

    /**
     * 根据开始时间和结束时间查询接口并更新
     * @param start 开始时间
     * @param end 结束时间
     * @param type 订单类型
     */
    void queryApiAndUpdate(LocalDateTime start, LocalDateTime end, OrderTypeEnum type);

    /**
     * 定时拉取渠道订单-入口在定时器
     * 拉取订单主要为两块,每20分钟启动一次,一、将淘宝的订单信息转换为自身平台的订单信息,二、给用户相关添加佣金
     */
    void pullOrder();

    /**
     * 定时拉取渠道订单半天启动一次-入口在定时器
     * 为了做容错处理(漏单)-每半天启动一次
     */
    void pullOrderByDay();

    /**
     * 定时拉取常规订单
     */
    void pullGeneralOrder();

    /**
     * 定时更新渠道订单状态
     * <p>
     * 分两种情况进行同步
     * 1--是订单创建距当前时间大于30天的 统一放到一个list当中
     * 2--是30天内的订单
     */
    void syncChannelOrderStatus();

    /**
     * 定时同步常规订单
     */
    void syncGeneralOrderStatus();

}
