package com.bxm.component.tbk.order.service;

import com.bxm.component.tbk.order.model.enums.TakeOutOrderSource;

import java.util.Date;

/**
 * 外卖订单佣金结算
 * @author Gonzo
 * @date  2020-05-03 16:58
 * @since 2.0.0
 */
public interface TakeOutOrderCommissionService {

    /**
     * 查询未返佣的外卖订单进行批量佣金结算
     * @param source 外卖订单类型
     * @param timeLimit 截止时间 (查询当前时间之前的未结算)
     */
    void commissionSettleByOrderTypeAndTimeBefore(TakeOutOrderSource source, Date timeLimit);

}
