package com.bxm.component.tbk.order.service.impl;

import com.bxm.component.tbk.order.model.enums.TakeOutOrderSource;
import com.bxm.component.tbk.order.service.TakeOutOrderCommissionService;
import lombok.extern.slf4j.Slf4j;

import java.util.Date;

/**
 * 外卖订单佣金结算
 * @author Gonzo
 * @date  2020-05-03 16:58
 * @since 2.0.0
 */
@Slf4j
public abstract class AbstractTakeOutOrderCommissionService implements TakeOutOrderCommissionService {

    @Override
    public void commissionSettleByOrderTypeAndTimeBefore(TakeOutOrderSource source, Date timeLimit) {
        log.info("外卖订单佣金结算，结算来源: {} 截止时间: {}", source, timeLimit);

        try {
            doCommissionSettleByOrderTypeAndTimeBefore(source, timeLimit);
        } catch(Exception e) {
            log.error("外卖订单佣金结算 处理失败 结算来源: {} 截止时间: {}", source, timeLimit, e);
        }
    }

    /**
     * 外卖订单佣金结算
     * @param source 外卖订单类型
     * @param timeLimit 截止时间
     */
    protected abstract void doCommissionSettleByOrderTypeAndTimeBefore(TakeOutOrderSource source, Date timeLimit);

}
