package com.bxm.component.tbk.order.timer;

import com.bxm.component.tbk.order.config.OrderTimerConfigProperties;
import com.bxm.component.tbk.order.config.TbkOpenOrderProperties;
import com.bxm.component.tbk.order.model.enums.TakeOutOrderSource;
import com.bxm.component.tbk.order.service.EleTakeOutOrderService;
import com.bxm.component.tbk.order.service.TakeOutOrderCommissionService;
import com.bxm.newidea.component.schedule.task.AbstractCronTask;
import com.bxm.newidea.component.tools.DateUtils;
import com.xxl.job.core.biz.model.ReturnT;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.util.Calendar;

/**
 * 饿了么订单状态同步和佣金结算
 * 每日11点
 *
 * @author Gonzo
 * @date 2020-03-26 16:34
 * @since 1.6.1
 */
@Component
@Slf4j
@AllArgsConstructor
public class EleOrderStatusSyncAndCommissionSettleDaysTask extends AbstractCronTask<String> {

    private final EleTakeOutOrderService eleTakeOutOrderService;

    private final TakeOutOrderCommissionService takeOutOrderCommissionSettleService;

    private final OrderTimerConfigProperties orderTimerConfigProperties;

    private final TbkOpenOrderProperties tbkOpenOrderProperties;

    @Override
    protected ReturnT<String> service(String s) {
        log.info("执行任务: {} 开始", taskName());
        try {
            // 先同步订单状态
            eleTakeOutOrderService.syncOrderStatusDays();

            Calendar calendar = Calendar.getInstance();
            // 提前一天
            calendar.add(Calendar.DAY_OF_MONTH, -1);

            // 将三方已结算的订单进行结算
            takeOutOrderCommissionSettleService.commissionSettleByOrderTypeAndTimeBefore(TakeOutOrderSource.ELE,
                    // 提前一天的截止时间
                    DateUtils.getDayEndTime(calendar.getTime()));

            log.info("执行任务: {} 结束", taskName());
        } catch (Exception e) {
            log.error("执行任务: {} 失败", taskName(), e);
            return ReturnT.FAIL;
        }


        return ReturnT.SUCCESS;
    }

    @Override
    public String taskName() {
        return "每日饿了么订单状态同步和佣金结算_" + tbkOpenOrderProperties.getSite();
    }

    @Override
    public String cron() {
        if (log.isDebugEnabled()) {
            log.debug("{}: {}", taskName(), orderTimerConfigProperties.getEleOrderStatusSyncAndCommissionSettleDaysCron());
        }

        return orderTimerConfigProperties.getEleOrderStatusSyncAndCommissionSettleDaysCron();
    }
}
